#!/bin/bash

log_debug() {
    [[ -L /dev/log || -f /dev/log ]] && logger -p local3.debug -t build_system[$$] $@
    echo "[DEBUG] $@"
}
log_info() {
    [[ -L /dev/log || -f /dev/log ]] && logger -p local3.info -t build_system[$$] $@
    echo "[INFO] $@"
}
log_warning() {
    [[ -L /dev/log || -f /dev/log ]] && logger -p local3.warning -t build_system[$$] $@
    echo "[WARN] $@"
}
log_error() {
    [[ -L /dev/log || -f /dev/log ]] && logger -p local3.err -t build_system[$$] $@
    echo "[ERROR] $@" >&2
}

SoftIrqPID=$(pgrep -o -f "ksoftirqd/2")
if [ ! -z "${SoftIrqPID}" ]; then
    log_info "ksoftirqd/2 进程已找到。"
    echo ksoftirqd/2 pid : $SoftIrqPID
    which chrt && chrt -f -p 99 $SoftIrqPID
fi