#!/bin/bash -e

mkdir -p /var/log/UnixBench/
cd /usr/local/UnixBench

# 启动
start() {
    # 根据系统架构修改makefile文件
    if [ $(uname -m) == "aarch64" ]
    then
        sed -i "s/CFLAGS = -Wall -g -O2/CFLAGS = -Wall -g -O2 -march=armv8-a/" ./Makefile
    fi
    mkdir -p results/ && rm -rf results/*
    nohup ./Run &>/var/log/UnixBench/byte-unixbench.log &
}

# 停止
stop() {
    pkill -9 Run
}

# 查看日志
log() {
    tail -f /var/log/UnixBench/byte-unixbench.log
}

# 启动，停止，查看日志
case $1 in
    start)
        start
        ;;
    stop)
        stop
        ;;
    log)
        log
        ;;
    *)
        echo "Usage: $0 {start|stop|log}"
        exit 1
esac
