#!/bin/bash

# create_ap 配置调整脚本
CONFIG_FILE="/etc/create_ap.conf"

# 函数：检测无线网卡
# 使用多种方法尝试识别系统中的无线网卡
detect_wireless_interface() {
    # 方法1: 使用 lshw 工具检测无线网卡
    #WIFI_IFACE=$(lshw -c network -class nic 2>/dev/null | 
    #    awk -F ': ' '/description: Wireless interface/{w=1;next} 
    #    w && /logical name:/ && $2 ~ /^wl/{print $2; exit}')
    #
    ## 方法2: 使用 nmcli 作为备选检测方法
    #[ -z "$WIFI_IFACE" ] && WIFI_IFACE=$(nmcli device | awk '$2 == "wifi" {print $1; exit}')
    #
    ## 方法3: 检查 /sys 文件系统作为最终回退
    #[ -z "$WIFI_IFACE" ] && {
    #    for dev in /sys/class/net/*; do
    #        [ -e "$dev/wireless" ] && {
    #            WIFI_IFACE=$(basename "$dev")
    #            break
    #        }
    #    done
    #}
    WIFI_IFACE=$(sed -n 's/^WIFI_IFACE=//p' /etc/create_ap.conf)
    
    echo "$WIFI_IFACE"
}

# 函数：检测5GHz支持性
# 检查无线网卡是否支持5GHz频段
check_5ghz_support() {
    local iface="$1"
    local phy_name
    
    # 获取无线网卡的物理设备名
    phy_name=$(cat "/sys/class/net/$iface/phy80211/name" 2>/dev/null)
    [ -z "$phy_name" ] && return 0
    
    # 特别处理Intel网卡（通常不支持AP模式的5GHz）
    if grep -qi "Intel" "/sys/class/net/$iface/device/vendor" 2>/dev/null; then
        echo 0
        return
    fi
    
    # 使用iw工具检测物理设备是否支持5GHz频段
    if iw phy "$phy_name" info | grep -v "no IR" | grep -q "5180 MHz"; then
        echo 1
    else
        echo 0
    fi
}

# 函数：更新配置文件
# 根据检测结果修改create_ap.conf中的相关配置项
update_config() {
    local iface="$1"
    local enable_5g="$2"
    
    # 更新无线网卡接口配置
    # if grep -q "^WIFI_IFACE=" "$CONFIG_FILE"; then
    #     sed -i "s/^WIFI_IFACE=.*/WIFI_IFACE=$iface/" "$CONFIG_FILE"
    # else
    #     echo "WIFI_IFACE=$iface" >> "$CONFIG_FILE"
    # fi
    
    # 根据5GHz支持情况更新频段相关配置
    if [ "$enable_5g" -eq 1 ]; then
        CHANNEL=`iw list | egrep " 5[0-9]{3}" | grep dBm | sort -nr  |awk -F' |\[|\]' 'NR==1{print $5}'`
        echo "Enabling 5GHz configuration"
        # 更新现有配置项
        sed -i "s/^FREQ_BAND=.*/FREQ_BAND=5/" "$CONFIG_FILE"
        sed -i "s/^CHANNEL=.*/CHANNEL=$CHANNEL/" "$CONFIG_FILE"
        sed -i "s/^HT_CAPAB=.*/HT_CAPAB=[HT40+][SHORT-GI-40]/" "$CONFIG_FILE"
        sed -i "s/^IEEE80211N=.*/IEEE80211N=0/" "$CONFIG_FILE"
        sed -i "s/^IEEE80211AC=.*/IEEE80211AC=1/" "$CONFIG_FILE"

        # 确保配置项存在（如果原文件没有这些配置）
        grep -q "^FREQ_BAND=" "$CONFIG_FILE" || echo "FREQ_BAND=5" >> "$CONFIG_FILE"
        grep -q "^CHANNEL=" "$CONFIG_FILE" || echo "CHANNEL=$CHANNEL" >> "$CONFIG_FILE"
        grep -q "^HT_CAPAB=" "$CONFIG_FILE" || echo "HT_CAPAB=[HT40+][SHORT-GI-40]" >> "$CONFIG_FILE"
        grep -q "^IEEE80211N=" "$CONFIG_FILE" || echo "IEEE80211N=0" >> "$CONFIG_FILE"
        grep -q "^IEEE80211AC=" "$CONFIG_FILE" || echo "IEEE80211AC=1" >> "$CONFIG_FILE"
    else
        CHANNEL=`iw list | egrep " 2[0-9]{3}" | grep dBm | sort -nr  |awk -F' |\[|\]' 'NR==1{print $5}'`
        echo "Enabling 2.4GHz configuration"
        # 更新2.4GHz配置
        sed -i "s/^FREQ_BAND=.*/FREQ_BAND=2.4/" "$CONFIG_FILE"
        sed -i "s/^CHANNEL=.*/CHANNEL=$CHANNEL/" "$CONFIG_FILE"
        sed -i "s/^HT_CAPAB=.*/HT_CAPAB=[HT20][SHORT-GI-20]/" "$CONFIG_FILE"
        sed -i "s/^IEEE80211N=.*/IEEE80211N=1/" "$CONFIG_FILE"
        sed -i "s/^IEEE80211AC=.*/IEEE80211AC=0/" "$CONFIG_FILE"

        # 确保配置项存在
        grep -q "^FREQ_BAND=" "$CONFIG_FILE" || echo "FREQ_BAND=2.4" >> "$CONFIG_FILE"
        grep -q "^CHANNEL=" "$CONFIG_FILE" || echo "CHANNEL=$CHANNEL" >> "$CONFIG_FILE"
        grep -q "^HT_CAPAB=" "$CONFIG_FILE" || echo "HT_CAPAB=[HT20][SHORT-GI-20]" >> "$CONFIG_FILE"
        grep -q "^IEEE80211N=" "$CONFIG_FILE" || echo "IEEE80211N=1" >> "$CONFIG_FILE"
        grep -q "^IEEE80211AC=" "$CONFIG_FILE" || echo "IEEE80211AC=0" >> "$CONFIG_FILE"
    fi
}

# 主函数
# 脚本执行入口
main() {
    # 检查配置文件是否存在
    [ ! -f "$CONFIG_FILE" ] && {
        echo "Error: Configuration file $CONFIG_FILE not found!" >&2
        exit 1
    }
    
    # 检测无线网卡
    WIFI_IFACE=$(detect_wireless_interface)
    [ -z "$WIFI_IFACE" ] && {
        echo "Warning: No wireless interface detected, keeping original configuration" >&2
        exit 0
    }
    
    # 显示检测结果
    echo "Detected wireless interface: $WIFI_IFACE"
    ENABLE_5G=$(check_5ghz_support "$WIFI_IFACE")
    echo "5GHz support: $([ "$ENABLE_5G" -eq 1 ] && echo "Yes" || echo "No")"
    
    # 更新配置文件
    update_config "$WIFI_IFACE" "$ENABLE_5G"
    echo "Configuration updated successfully"
}

# 执行主函数
main
