/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.dispatch;

import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.utils.fun.FunHelper;
import com.aubo.netty.client.ChannelManager;
import com.aubo.netty.client.NettyClient;
import com.aubo.netty.client.common.ctx.GraphContext;
import com.aubo.netty.client.common.ctx.RobotContext;
import com.aubo.netty.client.common.enumpool.NavPlanType;
import com.aubo.netty.client.common.ex.RoutePlanException;
import com.aubo.netty.client.common.nav.Navigator;
import com.aubo.netty.client.common.nav.impl.NavFactory;
import com.aubo.netty.client.common.slam.template.SlamNavTemplate;
import com.aubo.system.domain.SysRobot;
import com.aubo.system.dto.NavToPathDTO;
import com.aubo.system.dto.NavToStationDTO;
import com.aubo.system.mapper.SysRobotMapper;
import com.aubo.system.mapper.SysRoutePlanMapper;
import com.aubo.system.service.NavigationService;
import io.netty.channel.Channel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5bfc\u822a")
@RestController
@RequestMapping(value={"/navigation"})
public class NavigationController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger((String)"navigation");
    @Autowired
    private NavigationService navigationService;
    @Autowired
    private SysRobotMapper robotMapper;
    @Autowired
    private SysRoutePlanMapper routePlanMapper;

    @ApiOperation(value="\u5bfc\u822a\u5230\u70b9")
    @PostMapping(value={"/toStation"})
    public AjaxResult toStation(@Validated @RequestBody NavToStationDTO dto) {
        AjaxResult r;
        try {
            String robotName = dto.getRobotName();
            SysRobot query = new SysRobot();
            query.setRobotEnable(Integer.valueOf(1));
            query.setRobotStatus(Integer.valueOf(1));
            query.setRobotName(robotName);
            SysRobot entity = this.robotMapper.entityOf(query);
            if (entity == null) {
                throw new RoutePlanException("\u673a\u5668\u4eba\u4e0d\u53ef\u7528!");
            }
            Long robotNo = entity.getRobotNo();
            if (!this.robotMapper.tryReverseIdle(robotNo, Integer.valueOf(0))) {
                throw new RoutePlanException("\u673a\u5668\u4eba\u975e\u7a7a\u95f2!");
            }
            try {
                String routeType = this.routePlanMapper.selectSysRoutePlanByRouteNo(Long.valueOf(1L)).getPlanType();
                Optional stationOp = NettyClient.stationOf((String)entity.getRobotName());
                if (!stationOp.isPresent()) {
                    throw new RoutePlanException("\u7f3a\u5931\u673a\u5668\u4eba\u5f53\u524d\u7ad9\u70b9\u4fe1\u606f,\u65e0\u6cd5\u5b8c\u6210\u89c4\u5212!");
                }
                Channel navChannel = ChannelManager.navChannelOf((SysRobot)entity);
                SlamNavTemplate.releasePriority((Channel)navChannel);
                if (!SlamNavTemplate.setPriority((Channel)navChannel)) {
                    throw new RoutePlanException("\u62a2\u5360\u4f18\u5148\u6743\u5931\u8d25");
                }
                Navigator navigator = NavFactory.of((SysRobot)entity, (String)((String)stationOp.get()), (String)dto.getNavStationName(), (NavPlanType)NavPlanType.of((String)routeType));
                navigator.finallyAction(() -> this.robotMapper.tryReverseIdle(robotNo, Integer.valueOf(1)));
                navigator.whenArrived(FunHelper.NOTING_RUN);
                navigator.whenFailed(FunHelper.NOTING_RUN);
                navigator.whenCaughtEx(e -> {});
                navigator.planAndNav();
                r = AjaxResult.success();
            }
            catch (Exception e2) {
                this.robotMapper.tryReverseIdle(robotNo, Integer.valueOf(1));
                throw e2;
            }
        }
        catch (RoutePlanException e3) {
            r = AjaxResult.warn((String)e3.getMessage());
        }
        catch (Exception e4) {
            String msg = "\u673a\u5668\u4eba" + dto.getRobotName() + "\u5bfc\u822a\u5f02\u5e38";
            log.error(msg, (Throwable)e4);
            r = AjaxResult.error();
        }
        return r;
    }

    @ApiOperation(value="\u6682\u505c\u5bfc\u822a")
    @PostMapping(value={"/pause"})
    @Transactional
    public AjaxResult pauseRobot(@RequestBody String robotName) {
        AjaxResult r;
        try {
            SysRobot query = new SysRobot();
            query.setRobotName(robotName);
            SysRobot entity = this.robotMapper.getSysRobotInfoByRobotName(query);
            if (entity == null) {
                throw new RoutePlanException("\u673a\u5668\u4eba\u4e0d\u53ef\u7528!");
            }
            RobotContext rCtx = RobotContext.of((SysRobot)entity);
            rCtx.nav.pause();
            r = AjaxResult.success();
        }
        catch (RoutePlanException e) {
            r = AjaxResult.warn((String)e.getMessage());
        }
        catch (Exception e) {
            String msg = "\u673a\u5668\u4eba" + robotName + "\u7ee7\u7eed\u5f02\u5e38";
            log.error(msg, (Throwable)e);
            r = AjaxResult.error();
        }
        return r;
    }

    @ApiOperation(value="\u7ee7\u7eed\u5bfc\u822a")
    @PostMapping(value={"/resume"})
    @Transactional
    public AjaxResult resumeRobot(@RequestBody String robotName) {
        AjaxResult r;
        try {
            SysRobot query = new SysRobot();
            query.setRobotName(robotName);
            SysRobot entity = this.robotMapper.getSysRobotInfoByRobotName(query);
            if (entity == null) {
                throw new RoutePlanException("\u673a\u5668\u4eba\u4e0d\u53ef\u7528!");
            }
            RobotContext rCtx = RobotContext.of((SysRobot)entity);
            rCtx.nav.resume();
            r = AjaxResult.success();
        }
        catch (RoutePlanException e) {
            r = AjaxResult.warn((String)e.getMessage());
        }
        catch (Exception e) {
            String msg = "\u673a\u5668\u4eba" + robotName + "\u7ee7\u7eed\u5f02\u5e38";
            log.error(msg, (Throwable)e);
            r = AjaxResult.error();
        }
        return r;
    }

    @ApiOperation(value="\u8def\u5f84\u5bfc\u822a")
    @PostMapping(value={"/toPath"})
    @Transactional
    public AjaxResult toPath(@Validated @RequestBody NavToPathDTO dto) {
        AjaxResult r;
        try {
            GraphContext nowContext = GraphContext.now();
            List path = dto.getNavPath();
            boolean legalPath = GraphContext.now().helper.ensurePath(path);
            if (!legalPath) {
                throw new RoutePlanException("\u8def\u5f84\u5b58\u5728\u65e0\u6cd5\u901a\u884c\u8def\u6bb5");
            }
            String robotName = dto.getRobotName();
            SysRobot query = new SysRobot();
            query.setRobotEnable(Integer.valueOf(1));
            query.setRobotStatus(Integer.valueOf(1));
            query.setRobotName(robotName);
            SysRobot entity = this.robotMapper.entityOf(query);
            if (entity == null) {
                throw new RoutePlanException("\u673a\u5668\u4eba\u4e0d\u53ef\u7528!");
            }
            Long robotNo = entity.getRobotNo();
            if (!this.robotMapper.tryReverseIdle(robotNo, Integer.valueOf(0))) {
                throw new RoutePlanException("\u673a\u5668\u4eba\u975e\u7a7a\u95f2!");
            }
            try {
                Optional stationOp = NettyClient.stationOf((String)entity.getRobotName());
                if (!stationOp.isPresent()) {
                    throw new RoutePlanException("\u7f3a\u5931\u673a\u5668\u4eba\u5f53\u524d\u7ad9\u70b9\u4fe1\u606f,\u65e0\u6cd5\u5b8c\u6210\u89c4\u5212!");
                }
                Navigator navigator = NavFactory.ofFixedPath((SysRobot)entity, (List)path);
                navigator.finallyAction(() -> this.robotMapper.tryReverseIdle(robotNo, Integer.valueOf(1)));
                navigator.whenArrived(FunHelper.NOTING_RUN);
                navigator.whenFailed(FunHelper.NOTING_RUN);
                navigator.whenCaughtEx(e -> {});
                navigator.planAndNav();
                r = AjaxResult.success();
            }
            catch (Exception e2) {
                this.robotMapper.tryReverseIdle(robotNo, Integer.valueOf(1));
                throw e2;
            }
        }
        catch (RoutePlanException e3) {
            r = AjaxResult.warn((String)e3.getMessage());
        }
        catch (Exception e4) {
            String msg = "\u673a\u5668\u4eba" + dto.getRobotName() + "\u5bfc\u822a\u5f02\u5e38";
            log.error(msg, (Throwable)e4);
            r = AjaxResult.error();
        }
        return r;
    }
}

