/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysCharge;
import com.aubo.system.service.ISysChargeService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/charge"})
public class SysChargeController
extends BaseController {
    @Autowired
    private ISysChargeService sysChargeService;

    @PreAuthorize(value="@ss.hasPermi('system:charge:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysCharge sysCharge) {
        this.startPage();
        List list = this.sysChargeService.selectSysChargeList(sysCharge);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:charge:export')")
    @Log(title="\u5145\u7535\u7ad9\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysCharge sysCharge) {
        List list = this.sysChargeService.selectSysChargeList(sysCharge);
        ExcelUtil util = new ExcelUtil(SysCharge.class);
        util.exportExcel(response, list, "\u5145\u7535\u7ad9\u4fe1\u606f\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:charge:query')")
    @GetMapping(value={"/{chargeNo}"})
    public AjaxResult getInfo(@PathVariable(value="chargeNo") Long chargeNo) {
        return this.success((Object)this.sysChargeService.selectSysChargeByChargeNo(chargeNo));
    }

    @PreAuthorize(value="@ss.hasPermi('system:charge:add')")
    @Log(title="\u5145\u7535\u7ad9\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysCharge sysCharge) {
        return this.toAjax(this.sysChargeService.insertSysCharge(sysCharge));
    }

    @PreAuthorize(value="@ss.hasPermi('system:charge:edit')")
    @Log(title="\u5145\u7535\u7ad9\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysCharge sysCharge) {
        return this.toAjax(this.sysChargeService.updateSysCharge(sysCharge));
    }

    @PreAuthorize(value="@ss.hasPermi('system:charge:remove')")
    @Log(title="\u5145\u7535\u7ad9\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{chargeNos}"})
    public AjaxResult remove(@PathVariable Long[] chargeNos) {
        return this.toAjax(this.sysChargeService.deleteSysChargeByChargeNos(chargeNos));
    }
}

