/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysCrossing;
import com.aubo.system.service.ISysCrossingService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/crossing"})
public class SysCrossingController
extends BaseController {
    @Autowired
    private ISysCrossingService sysCrossingService;

    @PreAuthorize(value="@ss.hasPermi('system:crossing:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysCrossing sysCrossing) {
        this.startPage();
        List list = this.sysCrossingService.selectSysCrossingList(sysCrossing);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:crossing:export')")
    @Log(title="\u4ea4\u901a\u7ba1\u5236\u533a\u57df\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysCrossing sysCrossing) {
        List list = this.sysCrossingService.selectSysCrossingList(sysCrossing);
        ExcelUtil util = new ExcelUtil(SysCrossing.class);
        util.exportExcel(response, list, "\u4ea4\u901a\u7ba1\u5236\u533a\u57df\u4fe1\u606f\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:crossing:query')")
    @GetMapping(value={"/{crossingNo}"})
    public AjaxResult getInfo(@PathVariable(value="crossingNo") Long crossingNo) {
        return this.success((Object)this.sysCrossingService.selectSysCrossingByCrossingNo(crossingNo));
    }

    @PreAuthorize(value="@ss.hasPermi('system:crossing:add')")
    @Log(title="\u4ea4\u901a\u7ba1\u5236\u533a\u57df\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysCrossing sysCrossing) {
        return this.toAjax(this.sysCrossingService.insertSysCrossing(sysCrossing));
    }

    @PreAuthorize(value="@ss.hasPermi('system:crossing:edit')")
    @Log(title="\u4ea4\u901a\u7ba1\u5236\u533a\u57df\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysCrossing sysCrossing) {
        return this.toAjax(this.sysCrossingService.updateSysCrossing(sysCrossing));
    }

    @PreAuthorize(value="@ss.hasPermi('system:crossing:remove')")
    @Log(title="\u4ea4\u901a\u7ba1\u5236\u533a\u57df\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{crossingNos}"})
    public AjaxResult remove(@PathVariable Long[] crossingNos) {
        return this.toAjax(this.sysCrossingService.deleteSysCrossingByCrossingNos(crossingNos));
    }

    @PreAuthorize(value="@ss.hasPermi('system:crossing:reset')")
    @Log(title="\u4ea4\u901a\u7ba1\u5236\u533a\u57df\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/reset"})
    public AjaxResult reset(@RequestBody SysCrossing sysCrossing) {
        sysCrossing.setRobotName("");
        return this.toAjax(this.sysCrossingService.updateSysCrossing(sysCrossing));
    }
}

