/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Anonymous;
import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysEmulate;
import com.aubo.system.domain.SysRobot;
import com.aubo.system.event.AddEmulateEvent;
import com.aubo.system.event.DeleteRobotEvent;
import com.aubo.system.service.ISysEmulateService;
import com.aubo.system.service.ISysRobotService;
import com.aubo.web.controller.system.SysRobotController;
import io.swagger.annotations.Api;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u4eff\u771f\u673a\u5668\u4eba\u4fe1\u606f")
@Anonymous
@RestController
@RequestMapping(value={"/system/emulate"})
public class SysEmulateController
extends BaseController {
    @Autowired
    private ISysEmulateService sysEmulateService;
    @Autowired
    private ISysRobotService sysRobotService;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    private SysRobotController sysRobotController;

    @PreAuthorize(value="@ss.hasPermi('system:emulate:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysEmulate sysEmulate) {
        this.startPage();
        List list = this.sysEmulateService.selectSysEmulateList(sysEmulate);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:emulate:export')")
    @Log(title="\u4eff\u771f\u673a\u5668\u4eba\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysEmulate sysEmulate) {
        List list = this.sysEmulateService.selectSysEmulateList(sysEmulate);
        ExcelUtil util = new ExcelUtil(SysEmulate.class);
        util.exportExcel(response, list, "\u4eff\u771f\u673a\u5668\u4eba\u4fe1\u606f\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:emulate:query')")
    @GetMapping(value={"/{emulateId}"})
    public AjaxResult getInfo(@PathVariable(value="emulateId") Long emulateId) {
        return this.success((Object)this.sysEmulateService.selectSysEmulateByEmulateId(emulateId));
    }

    @PreAuthorize(value="@ss.hasPermi('system:emulate:add')")
    @Log(title="\u4eff\u771f\u673a\u5668\u4eba\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysEmulate sysEmulate) {
        this.applicationContext.publishEvent((ApplicationEvent)new AddEmulateEvent((Object)this, sysEmulate));
        SysRobot sysRobot = new SysRobot();
        sysRobot = this.addNormalRobot(sysRobot);
        String robotIp = sysEmulate.getEmulateIp();
        String robotName = sysEmulate.getEmulateName();
        String dockingStation = sysEmulate.getEmulateLocation();
        sysRobot.setDockingStation(dockingStation);
        sysRobot.setRobotIp(robotIp);
        sysRobot.setRobotName(robotName);
        this.sysRobotController.add(sysRobot);
        return this.toAjax(this.sysEmulateService.insertSysEmulate(sysEmulate));
    }

    @PreAuthorize(value="@ss.hasPermi('system:emulate:edit')")
    @Log(title="\u4eff\u771f\u673a\u5668\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysEmulate sysEmulate) {
        String emulateIp = sysEmulate.getEmulateIp();
        SysRobot sysRobot = this.sysRobotService.selectSysRobotByRobotIp(emulateIp);
        String robotName = sysEmulate.getEmulateName();
        String dockingStation = sysEmulate.getEmulateLocation();
        sysRobot.setDockingStation(dockingStation);
        sysRobot.setRobotIp(emulateIp);
        sysRobot.setRobotName(robotName);
        this.sysRobotService.updateSysRobot(sysRobot);
        return this.toAjax(this.sysEmulateService.updateSysEmulate(sysEmulate));
    }

    @PreAuthorize(value="@ss.hasPermi('system:emulate:remove')")
    @Log(title="\u4eff\u771f\u673a\u5668\u4eba\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{emulateIps}"})
    public AjaxResult remove(@PathVariable String[] emulateIps) {
        for (int i = 0; i < emulateIps.length; ++i) {
            SysEmulate sysEmulate = this.sysEmulateService.selectSysEmulateByEmulateIp(emulateIps[i]);
            String emulateIP = sysEmulate.getEmulateIp();
            SysRobot sysRobot = this.sysRobotService.selectSysRobotByRobotIp(emulateIP);
            this.applicationContext.publishEvent((ApplicationEvent)new DeleteRobotEvent((Object)this, sysRobot));
        }
        this.sysRobotService.deleteSysRobotByRobotIps(emulateIps);
        return this.toAjax(this.sysEmulateService.deleteSysEmulateByEmulateIps(emulateIps));
    }

    public SysRobot addNormalRobot(SysRobot sysRobot) {
        sysRobot.setRobotIdle(Integer.valueOf(1));
        sysRobot.setRobotEnable(Integer.valueOf(1));
        sysRobot.setRobotType(Long.valueOf(3L));
        sysRobot.setRobotStatus(Integer.valueOf(1));
        sysRobot.setRobotBatteryLower("0.8");
        sysRobot.setBatteryBusyLower("0.1");
        sysRobot.setBatteryBusyUpper("0.5");
        sysRobot.setBatteryFreeLower("0.5");
        sysRobot.setBatteryFreeUpper("0.9");
        sysRobot.setRobotMode(Integer.valueOf(0));
        sysRobot.setRobotBatteryLower("0.1");
        sysRobot.setRobotCharge("0");
        sysRobot.setRobotPriority("1");
        sysRobot.setRobotPriority("1");
        return sysRobot;
    }
}

