/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysEquipment;
import com.aubo.system.service.ISysEquipmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u8bbe\u5907\u4fe1\u606f")
@RestController
@RequestMapping(value={"/system/equipment"})
public class SysEquipmentController
extends BaseController {
    @Autowired
    private ISysEquipmentService sysEquipmentService;

    @ApiOperation(value="\u67e5\u8be2\u8bbe\u5907\u4fe1\u606f\u5217\u8868")
    @PreAuthorize(value="@ss.hasPermi('system:equipment:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysEquipment sysEquipment) {
        this.startPage();
        List list = this.sysEquipmentService.selectSysEquipmentList(sysEquipment);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:equipment:export')")
    @Log(title="\u8bbe\u5907\u6570\u636e", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysEquipment sysEquipment) {
        List list = this.sysEquipmentService.selectSysEquipmentList(sysEquipment);
        ExcelUtil util = new ExcelUtil(SysEquipment.class);
        util.exportExcel(response, list, "\u8bbe\u5907\u6570\u636e\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:equipment:query')")
    @GetMapping(value={"/{equipmentNo}"})
    public AjaxResult getInfo(@PathVariable(value="equipmentNo") Long equipmentNo) {
        return this.success((Object)this.sysEquipmentService.selectSysEquipmentByEquipmentNo(equipmentNo));
    }

    @PreAuthorize(value="@ss.hasPermi('system:equipment:add')")
    @Log(title="\u8bbe\u5907\u6570\u636e", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysEquipment sysEquipment) {
        return this.toAjax(this.sysEquipmentService.insertSysEquipment(sysEquipment));
    }

    @PreAuthorize(value="@ss.hasPermi('system:equipment:edit')")
    @Log(title="\u8bbe\u5907\u6570\u636e", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysEquipment sysEquipment) {
        return this.toAjax(this.sysEquipmentService.updateSysEquipment(sysEquipment));
    }

    @PreAuthorize(value="@ss.hasPermi('system:equipment:remove')")
    @Log(title="\u8bbe\u5907\u6570\u636e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{equipmentNos}"})
    public AjaxResult remove(@PathVariable Long[] equipmentNos) {
        return this.toAjax(this.sysEquipmentService.deleteSysEquipmentByEquipmentNos(equipmentNos));
    }
}

