/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysLift;
import com.aubo.system.service.ISysLiftService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/lift"})
public class SysLiftController
extends BaseController {
    @Autowired
    private ISysLiftService sysLiftService;

    @PreAuthorize(value="@ss.hasPermi('system:lift:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysLift sysLift) {
        this.startPage();
        List list = this.sysLiftService.selectSysLiftList(sysLift);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:lift:export')")
    @Log(title="\u7535\u68af\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysLift sysLift) {
        List list = this.sysLiftService.selectSysLiftList(sysLift);
        ExcelUtil util = new ExcelUtil(SysLift.class);
        util.exportExcel(response, list, "\u7535\u68af\u4fe1\u606f\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:lift:query')")
    @GetMapping(value={"/{liftId}"})
    public AjaxResult getInfo(@PathVariable(value="liftId") Long liftId) {
        return this.success((Object)this.sysLiftService.selectSysLiftByLiftId(liftId));
    }

    @PreAuthorize(value="@ss.hasPermi('system:lift:add')")
    @Log(title="\u7535\u68af\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysLift sysLift) {
        return this.toAjax(this.sysLiftService.insertSysLift(sysLift));
    }

    @PreAuthorize(value="@ss.hasPermi('system:lift:edit')")
    @Log(title="\u7535\u68af\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysLift sysLift) {
        return this.toAjax(this.sysLiftService.updateSysLift(sysLift));
    }

    @PreAuthorize(value="@ss.hasPermi('system:lift:remove')")
    @Log(title="\u7535\u68af\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{liftIds}"})
    public AjaxResult remove(@PathVariable Long[] liftIds) {
        return this.toAjax(this.sysLiftService.deleteSysLiftByLiftIds(liftIds));
    }
}

