/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aubo.common.annotation.Log;
import com.aubo.common.config.AuboConfig;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysLoadmap;
import com.aubo.system.service.ISysLoadmapService;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/loadmap"})
public class SysLoadmapController
extends BaseController {
    @Autowired
    private ISysLoadmapService sysLoadmapService;

    @ApiOperation(value="\u67e5\u8be2\u52a0\u8f7d\u5730\u56fe\u5217\u8868")
    @PreAuthorize(value="@ss.hasPermi('system:loadmap:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysLoadmap sysLoadmap) {
        this.startPage();
        List list = this.sysLoadmapService.selectSysLoadmapList(sysLoadmap);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u5bfc\u51fa\u52a0\u8f7d\u5730\u56fe\u5217\u8868")
    @PreAuthorize(value="@ss.hasPermi('system:loadmap:export')")
    @Log(title="\u52a0\u8f7d\u5730\u56fe", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysLoadmap sysLoadmap) {
        List list = this.sysLoadmapService.selectSysLoadmapList(sysLoadmap);
        ExcelUtil util = new ExcelUtil(SysLoadmap.class);
        util.exportExcel(response, list, "\u52a0\u8f7d\u5730\u56fe\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:loadmap:query')")
    @GetMapping(value={"/{mapNo}"})
    public AjaxResult getInfo(@PathVariable(value="mapNo") Long mapNo) {
        return this.success((Object)this.sysLoadmapService.selectSysLoadmapByMapNo(mapNo));
    }

    @ApiOperation(value="\u67e5\u8be2\u672c\u5730\u6587\u4ef6\u7684\u5730\u56fe\u5217\u8868")
    @PreAuthorize(value="@ss.hasPermi('system:loadmap:getFileName')")
    @GetMapping(value={"/getFileName"})
    public List<String> getFileName() {
        int i;
        HashMap mapData = new HashMap();
        ArrayList<String> data = new ArrayList<String>();
        ArrayList<String> png = new ArrayList<String>();
        List map1 = new ArrayList();
        List map2 = new ArrayList();
        String path = AuboConfig.getUploadPath();
        File file = new File(path);
        String[] fileName = file.list();
        for (int i2 = 0; i2 < fileName.length; ++i2) {
            if (fileName[i2].endsWith(".json")) {
                data.add(fileName[i2].substring(0, fileName[i2].lastIndexOf(".")));
            }
            if (!fileName[i2].endsWith(".png")) continue;
            png.add(fileName[i2].substring(0, fileName[i2].lastIndexOf(".")));
        }
        JSONObject mapObj = new JSONObject();
        JSONArray map = new JSONArray();
        map1 = (List)CollectionUtils.subtract(data, png);
        map2 = (List)CollectionUtils.intersection(data, png);
        for (i = 0; i < map1.size(); ++i) {
            mapObj.put((Object)"mapName", map1.get(i));
            mapObj.put((Object)"mapType", (Object)1);
            map.add((Object)mapObj);
        }
        for (i = 0; i < map2.size(); ++i) {
            mapObj.put((Object)"mapName", map2.get(i));
            mapObj.put((Object)"mapType", (Object)2);
            map.add((Object)mapObj);
        }
        System.out.println(map);
        List mapD = map.toList(String.class);
        return mapD;
    }

    @PreAuthorize(value="@ss.hasPermi('system:loadmap:add')")
    @Log(title="\u52a0\u8f7d\u5730\u56fe", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysLoadmap sysLoadmap) {
        return this.toAjax(this.sysLoadmapService.insertSysLoadmap(sysLoadmap));
    }

    @PreAuthorize(value="@ss.hasPermi('system:loadmap:edit')")
    @Log(title="\u52a0\u8f7d\u5730\u56fe", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysLoadmap sysLoadmap) {
        AjaxResult r = this.toAjax(this.sysLoadmapService.updateSysLoadmap(sysLoadmap));
        return r;
    }

    @PreAuthorize(value="@ss.hasPermi('system:loadmap:remove')")
    @Log(title="\u52a0\u8f7d\u5730\u56fe", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{mapNos}"})
    public AjaxResult remove(@PathVariable Long[] mapNos) {
        return this.toAjax(this.sysLoadmapService.deleteSysLoadmapByMapNos(mapNos));
    }
}

