/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysRlog;
import com.aubo.system.service.ISysRlogService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/rlog"})
public class SysRlogController
extends BaseController {
    @Autowired
    private ISysRlogService sysRlogService;

    @PreAuthorize(value="@ss.hasPermi('system:rlog:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysRlog sysRlog) {
        this.startPage();
        List list = this.sysRlogService.selectSysRlogList(sysRlog);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:rlog:export')")
    @Log(title="\u673a\u5668\u4eba\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysRlog sysRlog) {
        List list = this.sysRlogService.selectSysRlogList(sysRlog);
        ExcelUtil util = new ExcelUtil(SysRlog.class);
        util.exportExcel(response, list, "\u673a\u5668\u4eba\u65e5\u5fd7\u4fe1\u606f\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:rlog:query')")
    @GetMapping(value={"/{datetime}"})
    public AjaxResult getInfo(@PathVariable(value="datetime") Date datetime) {
        return this.success((Object)this.sysRlogService.selectSysRlogByDatetime(datetime));
    }

    @PreAuthorize(value="@ss.hasPermi('system:rlog:add')")
    @Log(title="\u673a\u5668\u4eba\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysRlog sysRlog) {
        return this.toAjax(this.sysRlogService.insertSysRlog(sysRlog));
    }

    @PreAuthorize(value="@ss.hasPermi('system:rlog:edit')")
    @Log(title="\u673a\u5668\u4eba\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysRlog sysRlog) {
        return this.toAjax(this.sysRlogService.updateSysRlog(sysRlog));
    }

    @PreAuthorize(value="@ss.hasPermi('system:rlog:remove')")
    @Log(title="\u673a\u5668\u4eba\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{datetimes}"})
    public AjaxResult remove(@PathVariable Date[] datetimes) {
        return this.toAjax(this.sysRlogService.deleteSysRlogByDatetimes(datetimes));
    }
}

