/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aubo.common.annotation.Anonymous;
import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.netty.client.common.enumpool.RobotType;
import com.aubo.netty.client.handler.NettyClientActiveHandlerTest;
import com.aubo.netty.client.handler.SlamNettyClientActiveHandler;
import com.aubo.system.domain.SysRobot;
import com.aubo.system.domain.SysTask;
import com.aubo.system.event.AddRobotEvent;
import com.aubo.system.event.DeleteRobotEvent;
import com.aubo.system.event.RobotEnableEvent;
import com.aubo.system.event.RobotManualDispatchEvent;
import com.aubo.system.event.RobotModifyEvent;
import com.aubo.system.mapper.SysRobotMapper;
import com.aubo.system.mapper.SysTaskMapper;
import com.aubo.system.service.ISysEmulateService;
import com.aubo.system.service.ISysRobotService;
import com.aubo.web.controller.system.SysRobotController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u673a\u5668\u4eba\u4fe1\u606f")
@Anonymous
@RestController
@RequestMapping(value={"/system/robot"})
public class SysRobotController
extends BaseController {
    @Resource
    private ISysRobotService sysRobotService;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private SysTaskMapper sysTaskMapper;
    @Resource
    private SysRobotMapper sysRobotMapper;
    @Resource
    private NettyClientActiveHandlerTest nettyClientActiveHandlerTest;
    @Resource
    private SlamNettyClientActiveHandler slamNettyClientActiveHandler;
    @Resource
    private ISysEmulateService sysEmulateService;
    private static Map<String, String> odoMap = new HashMap();

    @ApiOperation(value="\u67e5\u8be2\u673a\u5668\u4eba\u4fe1\u606f")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysRobot sysRobot) {
        this.startPage();
        List list = this.sysRobotService.selectSysRobotList(sysRobot);
        return this.getDataTable(list);
    }

    @Log(title="\u673a\u5668\u4eba\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysRobot sysRobot) {
        List list = this.sysRobotService.selectSysRobotList(sysRobot);
        ExcelUtil util = new ExcelUtil(SysRobot.class);
        util.exportExcel(response, list, "\u673a\u5668\u4eba\u4fe1\u606f\u6570\u636e");
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u5668\u4eba\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{robotNo}"})
    public AjaxResult getInfo(@PathVariable(value="robotNo") String robotNo) {
        return this.success((Object)this.sysRobotService.selectSysRobotByRobotNo(robotNo));
    }

    @ApiOperation(value="\u65b0\u589e\u673a\u5668\u4eba")
    @Log(title="\u673a\u5668\u4eba\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysRobot sysRobot) {
        AjaxResult r = this.toAjax(this.sysRobotService.insertSysRobot(sysRobot));
        if (r.isSuccess()) {
            SysRobot entity = this.sysRobotService.selectSysRobotByRobotNo(sysRobot.getRobotNo().toString());
            this.applicationContext.publishEvent((ApplicationEvent)new AddRobotEvent((Object)this, entity));
            this.applicationContext.publishEvent((ApplicationEvent)new RobotModifyEvent.Add((Object)this, entity));
        }
        return r;
    }

    @ApiOperation(value="\u4fee\u6539\u673a\u5668\u4eba\u4fe1\u606f")
    @Log(title="\u673a\u5668\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysRobot sysRobot) {
        Integer robotEnable = sysRobot.getRobotEnable();
        AjaxResult r = this.toAjax(this.sysRobotService.updateSysRobot(sysRobot));
        if (r.isSuccess()) {
            SysRobot now = this.sysRobotService.selectSysRobotByRobotNo(sysRobot.getRobotNo().toString());
            this.applicationContext.publishEvent((ApplicationEvent)new RobotEnableEvent((Object)this, robotEnable, now));
            this.applicationContext.publishEvent((ApplicationEvent)new RobotModifyEvent.Modify((Object)this, now));
        }
        return r;
    }

    @ApiOperation(value="\u5220\u9664\u673a\u5668\u4eba")
    @Log(title="\u673a\u5668\u4eba\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{robotIps}"})
    public AjaxResult remove(@PathVariable String[] robotIps) {
        ArrayList<String> emulateIps = new ArrayList<String>();
        for (int i = 0; i < robotIps.length; ++i) {
            SysRobot sysRobot = this.sysRobotService.selectSysRobotByRobotIp(robotIps[i]);
            this.applicationContext.publishEvent((ApplicationEvent)new DeleteRobotEvent((Object)this, sysRobot));
            this.applicationContext.publishEvent((ApplicationEvent)new RobotModifyEvent.Del((Object)this, sysRobot.getRobotNo()));
            if (sysRobot.getRobotType() != 3L) continue;
            emulateIps.add(robotIps[i]);
        }
        String[] array = new String[emulateIps.size()];
        for (int i = 0; i < emulateIps.size(); ++i) {
            array[i] = (String)emulateIps.get(i);
        }
        this.sysEmulateService.deleteSysEmulateByEmulateIps(array);
        return this.toAjax(this.sysRobotService.deleteSysRobotByRobotIps(robotIps));
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u5668\u4eba\u91cc\u7a0b")
    @PostMapping(value={"/odo"})
    public String getOdo() {
        List sysRobotList = this.sysRobotMapper.getSysRobotEnable();
        JSONObject odoInfo = new JSONObject();
        JSONArray odoArray = new JSONArray();
        for (SysRobot robot : sysRobotList) {
            String robotName = robot.getRobotName();
            JSONObject subObj = new JSONObject();
            SysRobot sysRobot = new SysRobot();
            sysRobot.setRobotName(robotName);
            sysRobot = this.sysRobotMapper.getSysRobotInfoByRobotName(sysRobot);
            RobotType type = RobotType.of((long)sysRobot.getRobotType());
            switch (1.$SwitchMap$com$aubo$netty$client$common$enumpool$RobotType[type.ordinal()]) {
                case 1: {
                    JSONObject jsonData = this.nettyClientActiveHandlerTest.getRobotMsg(robotName);
                    if (jsonData == null) break;
                    String odo = jsonData.getString("odo");
                    String todayOdo = jsonData.getString("todayOdo");
                    subObj.put((Object)"robotName", (Object)robotName);
                    subObj.put((Object)"totalDist", (Object)odo);
                    subObj.put((Object)"currentDist", (Object)todayOdo);
                    odoArray.add((Object)subObj);
                    odoInfo.put((Object)"info", (Object)odoArray);
                    break;
                }
                case 2: 
                case 3: {
                    JSONObject jsonData1 = this.slamNettyClientActiveHandler.getRobotMsg(robotName);
                    if (jsonData1 == null) break;
                    String totalDist = jsonData1.getString("totalDist");
                    String currentDist = jsonData1.getString("currentDist");
                    subObj.put((Object)"robotName", (Object)robotName);
                    subObj.put((Object)"totalDist", (Object)String.format("%.2f", Double.parseDouble(totalDist)));
                    subObj.put((Object)"currentDist", (Object)String.format("%.2f", Double.parseDouble(currentDist)));
                    odoArray.add((Object)subObj);
                    odoInfo.put((Object)robotName, (Object)odoArray);
                }
            }
        }
        return odoArray.toString();
    }

    @Log(title="\u673a\u5668\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/manual/{robotNo}/{taskNo}"})
    public AjaxResult manual(@PathVariable Long robotNo, @PathVariable Long taskNo) {
        SysTask sysTask = this.sysTaskMapper.selectSysTaskByTaskNo(taskNo);
        SysRobot sysRobot = this.sysRobotMapper.selectSysRobotByRobotNo(robotNo.toString());
        this.applicationContext.publishEvent((ApplicationEvent)new RobotManualDispatchEvent((Object)this, sysTask, sysRobot));
        return this.toAjax(this.sysRobotService.getRobotName(robotNo));
    }

    public static Map<String, String> getOdoMap() {
        return odoMap;
    }
}

