/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysRobotDispatch;
import com.aubo.system.service.ISysRobotDispatchService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/dispatch"})
public class SysRobotDispatchController
extends BaseController {
    @Autowired
    private ISysRobotDispatchService sysRobotDispatchService;

    @PreAuthorize(value="@ss.hasPermi('system:dispatch:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysRobotDispatch sysRobotDispatch) {
        this.startPage();
        List list = this.sysRobotDispatchService.selectSysRobotDispatchList(sysRobotDispatch);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:dispatch:export')")
    @Log(title="\u673a\u5668\u4eba\u8c03\u5ea6\u7b56\u7565\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysRobotDispatch sysRobotDispatch) {
        List list = this.sysRobotDispatchService.selectSysRobotDispatchList(sysRobotDispatch);
        ExcelUtil util = new ExcelUtil(SysRobotDispatch.class);
        util.exportExcel(response, list, "\u673a\u5668\u4eba\u8c03\u5ea6\u7b56\u7565\u4fe1\u606f\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:dispatch:query')")
    @GetMapping(value={"/{robotNo}"})
    public AjaxResult getInfo(@PathVariable(value="robotNo") Long robotNo) {
        return this.success((Object)this.sysRobotDispatchService.selectSysRobotDispatchByRobotNo(robotNo));
    }

    @PreAuthorize(value="@ss.hasPermi('system:dispatch:add')")
    @Log(title="\u673a\u5668\u4eba\u8c03\u5ea6\u7b56\u7565\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysRobotDispatch sysRobotDispatch) {
        return this.toAjax(this.sysRobotDispatchService.insertSysRobotDispatch(sysRobotDispatch));
    }

    @PreAuthorize(value="@ss.hasPermi('system:dispatch:edit')")
    @Log(title="\u673a\u5668\u4eba\u8c03\u5ea6\u7b56\u7565\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysRobotDispatch sysRobotDispatch) {
        return this.toAjax(this.sysRobotDispatchService.updateSysRobotDispatch(sysRobotDispatch));
    }

    @PreAuthorize(value="@ss.hasPermi('system:dispatch:remove')")
    @Log(title="\u673a\u5668\u4eba\u8c03\u5ea6\u7b56\u7565\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{robotNos}"})
    public AjaxResult remove(@PathVariable Long[] robotNos) {
        return this.toAjax(this.sysRobotDispatchService.deleteSysRobotDispatchByRobotNos(robotNos));
    }
}

