/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysRobotLog;
import com.aubo.system.dto.RobotLogQueryDTO;
import com.aubo.system.service.ISysRobotLogService;
import com.aubo.system.service.ISysRobotService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Api(value="\u673a\u5668\u4eba\u8fd0\u884c\u4fe1\u606f")
@RestController
@RequestMapping(value={"/system/log"})
public class SysRobotLogController
extends BaseController {
    @Autowired
    private ISysRobotLogService sysRobotLogService;
    @Autowired
    private ISysRobotService sysRobotService;

    @PreAuthorize(value="@ss.hasPermi('system:log:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysRobotLog sysRobotLog) {
        this.startPage();
        List list = this.sysRobotLogService.selectSysRobotLogList(sysRobotLog);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:log:export')")
    @Log(title="\u673a\u5668\u4eba\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysRobotLog sysRobotLog) {
        List list = this.sysRobotLogService.selectSysRobotLogList(sysRobotLog);
        ExcelUtil util = new ExcelUtil(SysRobotLog.class);
        util.exportExcel(response, list, "\u673a\u5668\u4eba\u65e5\u5fd7\u4fe1\u606f\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:log:query')")
    @GetMapping(value={"/{datetime}"})
    public AjaxResult getInfo(@PathVariable(value="datetime") Date datetime) {
        return this.success((Object)this.sysRobotLogService.selectSysRobotLogByDatetime(datetime));
    }

    @PreAuthorize(value="@ss.hasPermi('system:log:add')")
    @Log(title="\u673a\u5668\u4eba\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysRobotLog sysRobotLog) {
        return this.toAjax(this.sysRobotLogService.insertSysRobotLog(sysRobotLog));
    }

    @PreAuthorize(value="@ss.hasPermi('system:log:edit')")
    @Log(title="\u673a\u5668\u4eba\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysRobotLog sysRobotLog) {
        return this.toAjax(this.sysRobotLogService.updateSysRobotLog(sysRobotLog));
    }

    @PreAuthorize(value="@ss.hasPermi('system:log:remove')")
    @Log(title="\u673a\u5668\u4eba\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{datetimes}"})
    public AjaxResult remove(@PathVariable Date[] datetimes) {
        return this.toAjax(this.sysRobotLogService.deleteSysRobotLogByDatetimes(datetimes));
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u5668\u4eba\u8fd0\u884c\u6240\u6709\u4fe1\u606f")
    @PreAuthorize(value="@ss.hasPermi('system:log')")
    @GetMapping(value={"/robotLog"})
    public AjaxResult getLogInfo() throws Exception {
        String filePath = "D:\\aubo\\logs\\";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "robot-info" + df.format(new Date()) + ".txt";
        File logFile = new File(filePath + fileName);
        ArrayList<RobotLogQueryDTO> robotLogQueryDTOList = new ArrayList<RobotLogQueryDTO>();
        Map robotDayDate = SysRobotLogController.readFile((File)logFile);
        List listRobotName = (List)robotDayDate.get("robotName");
        List listWorkingTime = (List)robotDayDate.get("workingTime");
        ArrayList newRobotList = new ArrayList(new HashSet(listRobotName));
        List listX = (List)robotDayDate.get("robotLocX");
        List listY = (List)robotDayDate.get("robotLocY");
        List listVoltage = (List)robotDayDate.get("robotVoltage");
        List listCurrent = (List)robotDayDate.get("robotCurrent");
        Double[] robotDistanceDataDay = new Double[newRobotList.size()];
        Double[] robotMeanPowerDataDay = new Double[newRobotList.size()];
        Double[] robotMeanChargePowerDataDay = new Double[newRobotList.size()];
        Double[] robotDistanceDataMonth = new Double[newRobotList.size()];
        Double[] robotWorkTimeDataDay = new Double[newRobotList.size()];
        Double[] robotDistance = new Double[listX.size()];
        Double[] robotPower = new Double[listX.size()];
        for (int i = 0; i < newRobotList.size(); ++i) {
            RobotLogQueryDTO robotLogQueryDTO = new RobotLogQueryDTO();
            robotDistanceDataDay[i] = 0.0;
            robotMeanPowerDataDay[i] = 0.0;
            robotMeanChargePowerDataDay[i] = 0.0;
            robotWorkTimeDataDay[i] = 0.0;
            int number = 0;
            int dif = 0;
            String d1 = "";
            String d2 = "";
            for (int j = 1; j < listX.size(); ++j) {
                if (!((String)newRobotList.get(i)).equals(listRobotName.get(j))) continue;
                ++number;
                if (j - dif > 0) {
                    if (!(((String)listX.get(dif)).equals("") || ((String)listY.get(dif)).equals("") || ((String)listY.get(j)).equals("") || ((String)listY.get(j)).equals(""))) {
                        robotDistance[j] = Math.sqrt(Math.pow(Double.parseDouble((String)listX.get(j)) - Double.parseDouble((String)listX.get(dif)), 2.0) + Math.pow(Double.parseDouble((String)listY.get(j)) - Double.parseDouble((String)listY.get(dif)), 2.0));
                        robotDistanceDataDay[i] = robotDistanceDataDay[i] + robotDistance[j];
                        dif = j;
                    } else {
                        dif = j;
                    }
                    robotPower[j] = Double.parseDouble((String)listVoltage.get(j)) * Double.parseDouble((String)listCurrent.get(j));
                    if (robotPower[j] > 0.0) {
                        robotMeanPowerDataDay[i] = robotMeanPowerDataDay[i] + robotPower[j];
                    } else {
                        robotMeanChargePowerDataDay[i] = robotMeanChargePowerDataDay[i] + robotPower[j];
                    }
                }
                if (number == 1) {
                    d1 = (String)listWorkingTime.get(j);
                    continue;
                }
                d2 = (String)listWorkingTime.get(j);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date start = sdf.parse(d1);
            Date end = sdf.parse(d2);
            robotWorkTimeDataDay[i] = (double)(end.getTime() - start.getTime()) / 3600000.0;
            robotLogQueryDTO.setRobotName((String)newRobotList.get(i));
            robotLogQueryDTO.setMileageDay(String.format("%.2f", robotDistanceDataDay[i]));
            robotLogQueryDTO.setWorkTimeDay(String.format("%.2f", robotWorkTimeDataDay[i]));
            robotLogQueryDTO.setMeanPower(String.format("%.2f", robotMeanPowerDataDay[i] / (double)number));
            robotLogQueryDTOList.add(robotLogQueryDTO);
        }
        return AjaxResult.success(robotLogQueryDTOList);
    }

    private static Map<String, List<String>> readFile(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        ArrayList<String> listRobotName = new ArrayList<String>();
        ArrayList<String> listX = new ArrayList<String>();
        ArrayList<String> listY = new ArrayList<String>();
        ArrayList<String> listWorkingTime = new ArrayList<String>();
        ArrayList<String> listVoltage = new ArrayList<String>();
        ArrayList<String> listCurrent = new ArrayList<String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] param = line.split(",");
            String[] data = param[0].trim().split("\\s");
            String time = data[0].trim() + " " + data[1].trim();
            String robotName = data[2].trim();
            String locX = "0";
            String locY = "0";
            locX = param[1].trim();
            locY = param[2].trim();
            String voltage = param[6].trim();
            String current = param[7].trim();
            listWorkingTime.add(time);
            listRobotName.add(robotName);
            listX.add(locX);
            listY.add(locY);
            listVoltage.add(voltage);
            listCurrent.add(current);
        }
        HashMap<String, List<String>> robotData = new HashMap<String, List<String>>();
        robotData.put("workingTime", listWorkingTime);
        robotData.put("robotName", listRobotName);
        robotData.put("robotLocX", listX);
        robotData.put("robotLocY", listY);
        robotData.put("robotVoltage", listVoltage);
        robotData.put("robotCurrent", listCurrent);
        br.close();
        return robotData;
    }
}

