/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysRoutePlan;
import com.aubo.system.service.ISysRoutePlanService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/plan"})
public class SysRoutePlanController
extends BaseController {
    @Autowired
    private ISysRoutePlanService sysRoutePlanService;

    @PreAuthorize(value="@ss.hasPermi('system:plan:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysRoutePlan sysRoutePlan) {
        this.startPage();
        List list = this.sysRoutePlanService.selectSysRoutePlanList(sysRoutePlan);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:plan:export')")
    @Log(title="\u8def\u5f84\u89c4\u5212\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysRoutePlan sysRoutePlan) {
        List list = this.sysRoutePlanService.selectSysRoutePlanList(sysRoutePlan);
        ExcelUtil util = new ExcelUtil(SysRoutePlan.class);
        util.exportExcel(response, list, "\u8def\u5f84\u89c4\u5212\u4fe1\u606f\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:plan:query')")
    @GetMapping(value={"/{routeNo}"})
    public AjaxResult getInfo(@PathVariable(value="routeNo") Long routeNo) {
        return this.success((Object)this.sysRoutePlanService.selectSysRoutePlanByRouteNo(routeNo));
    }

    @PreAuthorize(value="@ss.hasPermi('system:plan:add')")
    @Log(title="\u8def\u5f84\u89c4\u5212\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysRoutePlan sysRoutePlan) {
        return this.toAjax(this.sysRoutePlanService.insertSysRoutePlan(sysRoutePlan));
    }

    @PreAuthorize(value="@ss.hasPermi('system:plan:edit')")
    @Log(title="\u8def\u5f84\u89c4\u5212\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysRoutePlan sysRoutePlan) {
        return this.toAjax(this.sysRoutePlanService.updateSysRoutePlan(sysRoutePlan));
    }

    @PreAuthorize(value="@ss.hasPermi('system:plan:remove')")
    @Log(title="\u8def\u5f84\u89c4\u5212\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{routeNos}"})
    public AjaxResult remove(@PathVariable Long[] routeNos) {
        return this.toAjax(this.sysRoutePlanService.deleteSysRoutePlanByRouteNos(routeNos));
    }
}

