/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysRobot;
import com.aubo.system.domain.SysTask;
import com.aubo.system.dto.RobotTaskListDTO;
import com.aubo.system.dto.TaskListQueryDTO;
import com.aubo.system.event.TaskPauseEvent;
import com.aubo.system.event.TaskResumeEvent;
import com.aubo.system.event.TaskSuspendEvent;
import com.aubo.system.mapper.SysTaskMapper;
import com.aubo.system.service.ISysRobotService;
import com.aubo.system.service.ISysTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u4efb\u52a1\u4fe1\u606f")
@RestController
@RequestMapping(value={"/system/task"})
public class SysTaskController
extends BaseController {
    @Autowired
    private ISysTaskService sysTaskService;
    @Autowired
    private SysTaskMapper sysTaskMapper;
    @Autowired
    private ISysRobotService sysRobotService;
    @Autowired
    ApplicationContext applicationContext;

    @ApiOperation(value="\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f\u5217\u8868")
    @PreAuthorize(value="@ss.hasPermi('system:task:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysTask sysTask) {
        System.out.println(Thread.currentThread().getName());
        this.startPage();
        List list = this.sysTaskService.selectSysTaskList(sysTask);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u5386\u53f2\u4efb\u52a1\u4fe1\u606f\u5217\u8868")
    @PreAuthorize(value="@ss.hasPermi('system:task:list')")
    @GetMapping(value={"/hisList"})
    public TableDataInfo hisList(TaskListQueryDTO sysTask) {
        System.out.println(Thread.currentThread().getName());
        this.startPage();
        List list = this.sysTaskService.queryTaskList(sysTask);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:task:export')")
    @Log(title="\u4efb\u52a1\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysTask sysTask) {
        List list = this.sysTaskService.selectSysTaskList(sysTask);
        ExcelUtil util = new ExcelUtil(SysTask.class);
        util.exportExcel(response, list, "\u4efb\u52a1\u4fe1\u606f\u6570\u636e");
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u8be6\u7ec6\u4fe1\u606f")
    @PreAuthorize(value="@ss.hasPermi('system:task:query')")
    @GetMapping(value={"/{taskNo}"})
    public AjaxResult getInfo(@PathVariable(value="taskNo") Long taskNo) {
        return this.success((Object)this.sysTaskService.selectSysTaskByTaskNo(taskNo));
    }

    @ApiOperation(value="\u65b0\u589e\u4efb\u52a1\u4fe1\u606f")
    @PreAuthorize(value="@ss.hasPermi('system:task:add')")
    @Log(title="\u4efb\u52a1\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysTask sysTask) {
        return this.toAjax(this.sysTaskService.insertSysTask(sysTask));
    }

    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u4fe1\u606f")
    @PreAuthorize(value="@ss.hasPermi('system:task:edit')")
    @Log(title="\u4efb\u52a1\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysTask sysTask) {
        return this.toAjax(this.sysTaskService.updateSysTask(sysTask));
    }

    @ApiOperation(value="\u53d6\u6d88\u4efb\u52a1")
    @PreAuthorize(value="@ss.hasPermi('system:task:cancel')")
    @Log(title="\u4efb\u52a1\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/cancel/{taskNo}"})
    public AjaxResult cancel(@PathVariable Long taskNo) {
        return this.toAjax(this.sysTaskService.cancelSysTask(taskNo));
    }

    @ApiOperation(value="\u6682\u505c\u4efb\u52a1")
    @PreAuthorize(value="@ss.hasPermi('system:task:pause')")
    @Log(title="\u6682\u505c\u4efb\u52a1\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/pause/{taskNo}"})
    public AjaxResult pause(@PathVariable Long taskNo) {
        SysTask sysTask = this.sysTaskMapper.selectSysTaskByTaskNo(taskNo);
        this.applicationContext.publishEvent((ApplicationEvent)new TaskPauseEvent((Object)this, sysTask));
        System.out.println("\u6682\u505c\u4efb\u52a1\u4e8b\u4ef6\u53d1\u5e03");
        return this.toAjax(this.sysTaskService.pauseSysTask(taskNo));
    }

    @ApiOperation(value="\u7ee7\u7eed\u4efb\u52a1")
    @PreAuthorize(value="@ss.hasPermi('system:task:resume')")
    @Log(title="\u7ee7\u7eed\u4efb\u52a1\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/resume/{taskNo}"})
    public AjaxResult resume(@PathVariable(value="taskNo") Long taskNo) {
        SysTask sysTask = this.sysTaskMapper.selectSysTaskByTaskNo(taskNo);
        this.applicationContext.publishEvent((ApplicationEvent)new TaskResumeEvent((Object)this, sysTask));
        return this.toAjax(this.sysTaskService.resumeSysTask(taskNo));
    }

    @ApiOperation(value="\u4e2d\u65ad\u4efb\u52a1")
    @PreAuthorize(value="@ss.hasPermi('system:task:suspend')")
    @Log(title="\u4e2d\u65ad\u4efb\u52a1\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/suspend/{taskNo}"})
    public AjaxResult suspend(@PathVariable Long taskNo) {
        SysTask sysTask = this.sysTaskMapper.selectSysTaskByTaskNo(taskNo);
        this.applicationContext.publishEvent((ApplicationEvent)new TaskSuspendEvent((Object)this, sysTask));
        return this.toAjax(this.sysTaskService.suspendSysTask(taskNo));
    }

    @ApiOperation(value="\u5220\u9664\u4efb\u52a1")
    @PreAuthorize(value="@ss.hasPermi('system:task:remove')")
    @Log(title="\u5220\u9664\u4efb\u52a1\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{taskNos}"})
    public AjaxResult remove(@PathVariable Long[] taskNos) {
        return this.toAjax(this.sysTaskService.deleteSysTaskByTaskNos(taskNos));
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u5668\u4eba\u6267\u884c\u4efb\u52a1\u6570\u636e")
    @PreAuthorize(value="@ss.hasPermi('system:task:robot')")
    @GetMapping(value={"/robot"})
    public AjaxResult getRobotTaskData() {
        ArrayList<RobotTaskListDTO> robotTaskListDTOS = new ArrayList<RobotTaskListDTO>();
        List robotList = this.sysRobotService.selectAllSysRobotList();
        String[] robotName = new String[robotList.size()];
        int[] robotTaskDay = new int[robotList.size()];
        int[] robotTaskMonth = new int[robotList.size()];
        for (int i = 0; i < robotList.size(); ++i) {
            robotName[i] = ((SysRobot)robotList.get(i)).getRobotName();
            RobotTaskListDTO robotTaskListDTO = new RobotTaskListDTO();
            robotTaskDay[i] = this.sysTaskService.selectSysRobotTaskCountDay(robotName[i]);
            robotTaskMonth[i] = this.sysTaskService.selectSysRobotTaskCountMonth(robotName[i]);
            robotTaskListDTO.setRobotName(robotName[i]);
            robotTaskListDTO.setDayTaskNum(robotTaskDay[i]);
            robotTaskListDTO.setMonthTaskNum(robotTaskMonth[i]);
            robotTaskListDTOS.add(robotTaskListDTO);
        }
        return AjaxResult.success(robotTaskListDTOS);
    }

    @ApiOperation(value="\u67e5\u8be2\u4efb\u52a1\u5404\u4e2a\u72b6\u6001\u6570\u636e")
    @PreAuthorize(value="@ss.hasPermi('system:task:taskstatus')")
    @GetMapping(value={"/taskstatus"})
    public AjaxResult getTaskData() {
        HashMap<String, Integer> taskDay = new HashMap<String, Integer>();
        HashMap<String, Integer> taskMonth = new HashMap<String, Integer>();
        taskDay.put("1", this.sysTaskService.selectSysUnDispatchTaskCount());
        taskMonth.put("1", this.sysTaskService.selectSysUnDispatchTaskCountMonth());
        for (long i = 2L; i < 14L; ++i) {
            String key = Long.toString(i);
            taskDay.put(key, this.sysTaskService.selectSysTaskCount(Long.valueOf(i)));
            taskMonth.put(key, this.sysTaskService.selectSysTaskCountMonth(Long.valueOf(i)));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"taskDayNum", taskDay);
        jsonObject.put((Object)"taskMonthNum", taskMonth);
        JSONArray taskData = new JSONArray();
        taskData.add((Object)jsonObject);
        return AjaxResult.success((Object)taskData);
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u5668\u4eba\u8fd1\u4e03\u65e5\u6267\u884c\u4efb\u52a1\u6570\u636e")
    @PreAuthorize(value="@ss.hasPermi('system:task:week')")
    @GetMapping(value={"/week"})
    public AjaxResult getTaskWeekData() {
        return AjaxResult.success((Object)this.sysTaskService.selectTaskDataWeek());
    }
}

