/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysTaskStrategies;
import com.aubo.system.service.ISysTaskStrategiesService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/strategies"})
public class SysTaskStrategiesController
extends BaseController {
    @Autowired
    private ISysTaskStrategiesService sysTaskStrategiesService;

    @PreAuthorize(value="@ss.hasPermi('system:strategies:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysTaskStrategies sysTaskStrategies) {
        this.startPage();
        List list = this.sysTaskStrategiesService.selectSysTaskStrategiesList(sysTaskStrategies);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:strategies:export')")
    @Log(title="\u4efb\u52a1\u7b56\u7565\u76f8\u5173", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysTaskStrategies sysTaskStrategies) {
        List list = this.sysTaskStrategiesService.selectSysTaskStrategiesList(sysTaskStrategies);
        ExcelUtil util = new ExcelUtil(SysTaskStrategies.class);
        util.exportExcel(response, list, "\u4efb\u52a1\u7b56\u7565\u76f8\u5173\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:strategies:query')")
    @GetMapping(value={"/{taskType}"})
    public AjaxResult getInfo(@PathVariable(value="taskType") Long taskType) {
        return this.success((Object)this.sysTaskStrategiesService.selectSysTaskStrategiesByTaskType(taskType));
    }

    @PreAuthorize(value="@ss.hasPermi('system:strategies:add')")
    @Log(title="\u4efb\u52a1\u7b56\u7565\u76f8\u5173", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysTaskStrategies sysTaskStrategies) {
        return this.toAjax(this.sysTaskStrategiesService.insertSysTaskStrategies(sysTaskStrategies));
    }

    @PreAuthorize(value="@ss.hasPermi('system:strategies:edit')")
    @Log(title="\u4efb\u52a1\u7b56\u7565\u76f8\u5173", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysTaskStrategies sysTaskStrategies) {
        return this.toAjax(this.sysTaskStrategiesService.updateSysTaskStrategies(sysTaskStrategies));
    }

    @PreAuthorize(value="@ss.hasPermi('system:strategies:remove')")
    @Log(title="\u4efb\u52a1\u7b56\u7565\u76f8\u5173", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{taskTypes}"})
    public AjaxResult remove(@PathVariable Long[] taskTypes) {
        return this.toAjax(this.sysTaskStrategiesService.deleteSysTaskStrategiesByTaskTypes(taskTypes));
    }
}

