/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysTestMessage;
import com.aubo.system.service.ISysTestMessageService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/message"})
public class SysTestMessageController
extends BaseController {
    @Autowired
    private ISysTestMessageService sysTestMessageService;

    @PreAuthorize(value="@ss.hasPermi('system:message:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysTestMessage sysTestMessage) {
        this.startPage();
        List list = this.sysTestMessageService.selectSysTestMessageList(sysTestMessage);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:message:export')")
    @Log(title="\u673a\u5668\u4eba\u79bb\u7ebf\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysTestMessage sysTestMessage) {
        List list = this.sysTestMessageService.selectSysTestMessageList(sysTestMessage);
        ExcelUtil util = new ExcelUtil(SysTestMessage.class);
        util.exportExcel(response, list, "\u673a\u5668\u4eba\u79bb\u7ebf\u65e5\u5fd7\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:message:query')")
    @GetMapping(value={"/{logId}"})
    public AjaxResult getInfo(@PathVariable(value="logId") Long logId) {
        return this.success((Object)this.sysTestMessageService.selectSysTestMessageByLogId(logId));
    }

    @PreAuthorize(value="@ss.hasPermi('system:message:add')")
    @Log(title="\u673a\u5668\u4eba\u79bb\u7ebf\u65e5\u5fd7", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysTestMessage sysTestMessage) {
        return this.toAjax(this.sysTestMessageService.insertSysTestMessage(sysTestMessage));
    }

    @PreAuthorize(value="@ss.hasPermi('system:message:edit')")
    @Log(title="\u673a\u5668\u4eba\u79bb\u7ebf\u65e5\u5fd7", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysTestMessage sysTestMessage) {
        return this.toAjax(this.sysTestMessageService.updateSysTestMessage(sysTestMessage));
    }

    @PreAuthorize(value="@ss.hasPermi('system:message:remove')")
    @Log(title="\u673a\u5668\u4eba\u79bb\u7ebf\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{logIds}"})
    public AjaxResult remove(@PathVariable Long[] logIds) {
        return this.toAjax(this.sysTestMessageService.deleteSysTestMessageByLogIds(logIds));
    }
}

