/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.controller.system;

import com.aubo.common.annotation.Log;
import com.aubo.common.core.controller.BaseController;
import com.aubo.common.core.domain.AjaxResult;
import com.aubo.common.core.page.TableDataInfo;
import com.aubo.common.enums.BusinessType;
import com.aubo.common.utils.poi.ExcelUtil;
import com.aubo.system.domain.SysTlog;
import com.aubo.system.service.ISysTlogService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/tlog"})
public class SysTlogController
extends BaseController {
    @Autowired
    private ISysTlogService sysTlogService;

    @PreAuthorize(value="@ss.hasPermi('system:tlog:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysTlog sysTlog) {
        this.startPage();
        List list = this.sysTlogService.selectSysTlogList(sysTlog);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:tlog:export')")
    @Log(title="\u673a\u5668\u4eba\u4efb\u52a1\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysTlog sysTlog) {
        List list = this.sysTlogService.selectSysTlogList(sysTlog);
        ExcelUtil util = new ExcelUtil(SysTlog.class);
        util.exportExcel(response, list, "\u673a\u5668\u4eba\u4efb\u52a1\u65e5\u5fd7\u4fe1\u606f\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:tlog:query')")
    @GetMapping(value={"/{messageId}"})
    public AjaxResult getInfo(@PathVariable(value="messageId") Long messageId) {
        return this.success((Object)this.sysTlogService.selectSysTlogByMessageId(messageId));
    }

    @PreAuthorize(value="@ss.hasPermi('system:tlog:add')")
    @Log(title="\u673a\u5668\u4eba\u4efb\u52a1\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysTlog sysTlog) {
        return this.toAjax(this.sysTlogService.insertSysTlog(sysTlog));
    }

    @PreAuthorize(value="@ss.hasPermi('system:tlog:edit')")
    @Log(title="\u673a\u5668\u4eba\u4efb\u52a1\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysTlog sysTlog) {
        return this.toAjax(this.sysTlogService.updateSysTlog(sysTlog));
    }

    @PreAuthorize(value="@ss.hasPermi('system:tlog:remove')")
    @Log(title="\u673a\u5668\u4eba\u4efb\u52a1\u65e5\u5fd7\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{messageIds}"})
    public AjaxResult remove(@PathVariable Long[] messageIds) {
        return this.toAjax(this.sysTlogService.deleteSysTlogByMessageIds(messageIds));
    }
}

