/*
 * Decompiled with CFR 0.152.
 */
package com.aubo.web.core.config;

import com.aubo.common.config.AuboConfig;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.auth.In;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
public class SwaggerConfig {
    @Autowired
    private AuboConfig auboConfig;
    @Value(value="${swagger.enabled}")
    private boolean enabled;
    @Value(value="${swagger.pathMapping}")
    private String pathMapping;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.OAS_30).enable(this.enabled).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build().securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts()).pathMapping(this.pathMapping);
    }

    private List<SecurityScheme> securitySchemes() {
        ArrayList<SecurityScheme> apiKeyList = new ArrayList<SecurityScheme>();
        apiKeyList.add((SecurityScheme)new ApiKey("Authorization", "Authorization", In.HEADER.toValue()));
        return apiKeyList;
    }

    private List<SecurityContext> securityContexts() {
        ArrayList<SecurityContext> securityContexts = new ArrayList<SecurityContext>();
        securityContexts.add(SecurityContext.builder().securityReferences(this.defaultAuth()).operationSelector(o -> o.requestMappingPattern().matches("/.*")).build());
        return securityContexts;
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        securityReferences.add(new SecurityReference("Authorization", authorizationScopes));
        return securityReferences;
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("\u9068\u535a\u590d\u5408\u673a\u5668\u4eba\u8c03\u5ea6\u7cfb\u7edf_\u63a5\u53e3\u6587\u6863").description("\u7528\u4e8e\u8c03\u5ea6\u7cfb\u7edf\u4e0b\u7684\u76f8\u5173\u4fe1\u606f,\u5177\u4f53\u5305\u62ec\u673a\u5668\u4eba\u3001\u4efb\u52a1\u6a21\u5757").contact(new Contact(this.auboConfig.getName(), null, null)).version("\u7248\u672c\u53f7:" + this.auboConfig.getVersion()).build();
    }
}

