$INSTALL_DIR = "C:\opt\aubofleet"
$JAR_FILE = "$INSTALL_DIR\lib\aubofleet.jar"
$PID_FILE = "$INSTALL_DIR\aubofleet.pid"
$LOG_FILE = "$INSTALL_DIR\aubofleet.log"

function Install {
    Write-Host "Installing aubofleet..."
    New-Item -ItemType Directory -Force -Path $INSTALL_DIR
    Copy-Item -Recurse -Path (Join-Path -Path (Split-Path -Parent $MyInvocation.MyCommand.Path) "..\*") -Destination $INSTALL_DIR
    Write-Host "Installation completed."
}

function Uninstall {
    Write-Host "Uninstalling aubofleet..."
    if (Test-Path $INSTALL_DIR) {
        Stop-Aubofleet -ErrorAction SilentlyContinue
        Remove-Item -Recurse -Force -Path $INSTALL_DIR
        Write-Host "Uninstallation completed."
    } else {
        Write-Host "No installation found."
    }
}

function Start-Aubofleet {
    Write-Host "Starting aubofleet..."
    if (Test-Path $PID_FILE) {
        Write-Host "aubofleet is already running."
        exit 1
    }
    Start-Process -FilePath "java" -ArgumentList "-jar `"$JAR_FILE`"" -RedirectStandardOutput $LOG_FILE -RedirectStandardError $LOG_FILE -NoNewWindow
    Write-Host "aubofleet started."
}

function Stop-Aubofleet {
    Write-Host "Stopping aubofleet..."
    if (Test-Path $PID_FILE) {
        $PID = Get-Content $PID_FILE
        Stop-Process -Id $PID -Force
        Remove-Item -Path $PID_FILE
        Write-Host "aubofleet stopped."
    } else {
        Write-Host "aubofleet is not running."
    }
}

function Restart-Aubofleet {
    Stop-Aubofleet
    Start-Aubofleet
}

function Show-Usage {
    Write-Host "Usage: .\manage.ps1 {install|uninstall|start|stop|restart}"
    exit 1
}

param (
    [string]$Action
)

switch ($Action) {
    "install" { Install }
    "uninstall" { Uninstall }
    "start" { Start-Aubofleet }
    "stop" { Stop-Aubofleet }
    "restart" { Restart-Aubofleet }
    default { Show-Usage }
}