#!/bin/bash
set -e

JAVA_HOME="$INSTALL_DIR/jdk"
PATH="$JAVA_HOME/bin:$PATH"
nohup $JAVA_HOME/bin/java $JVM_OPTS -jar $JAR_FILE > "$LOG_FILE" 2>&1 &
INSTALL_DIR="/opt/aubofleet"
JAR_FILE="$INSTALL_DIR/lib/aubofleet.jar"
PID_FILE="$INSTALL_DIR/aubofleet.pid"
LOG_FILE="$INSTALL_DIR/aubofleet.log"

function install() {
  echo "Installing aubofleet..."
  mkdir -p "$INSTALL_DIR"
  cp -r "$(dirname "$0")/.."/* "$INSTALL_DIR/"
  chmod +x "$INSTALL_DIR/scripts/manage.sh"
  echo "Installation completed."
}

function uninstall() {
  echo "Uninstalling aubofleet..."
  if [ -d "$INSTALL_DIR" ]; then
    stop || true
    rm -rf "$INSTALL_DIR"
    echo "Uninstallation completed."
  else
    echo "No installation found."
  fi
}

function start() {
  echo "Starting aubofleet..."
  if [ -f "$PID_FILE" ]; then
    echo "aubofleet is already running."
    exit 1
  fi
  nohup java -jar "$JAR_FILE" > "$LOG_FILE" 2>&1 &
  echo $! > "$PID_FILE"
  echo "aubofleet started."
}

function stop() {
  echo "Stopping aubofleet..."
  if [ -f "$PID_FILE" ]; then
    pkill -F "$PID_FILE"
    rm -f "$PID_FILE"
    echo "aubofleet stopped."
  else
    echo "aubofleet is not running."
  fi
}

function restart() {
  echo "Restarting aubofleet..."
  stop || true
  start
}

function usage() {
  echo "Usage: $0 {install|uninstall|start|stop|restart}"
  exit 1
}

case "$1" in
  install) install ;;
  uninstall) uninstall ;;
  start) start ;;
  stop) stop ;;
  restart) restart ;;
  *) usage ;;
esac