//
//  robotCrypto.h
//  AisinoExtractSMXAlg
//
//  Created by A-A-Dev on 2020/11/19.
//

#ifndef robotCrypto_h
#define robotCrypto_h

#ifdef R0B0T_CRYPTO_EXPORTS
#if defined(_WIN32) || defined(_WIN64)
#define ROBOT_CRYPTO_API __declspec(dllexport)
#else
#define ROBOT_CRYPTO_API __attribute__((visibility("default")))
#endif
#else
#if defined(_WIN32) || defined(_WIN64)
#define ROBOT_CRYPTO_API __declspec(dllimport)
#else
#define ROBOT_CRYPTO_API __attribute__((visibility("default")))
#endif
#endif

/**
 *函数说明：加密明文数据
 *参数说明：
 *pCryptoFactor，        输入参数，   密码运算因子，不能为空
 ulCryptoFactorLen，    输入参数，   密码运算因子长度
 *pPlainData，           输入参数，   待加密数据
 ulPlainDataLen，       输入参数，   以字节计算的待加密数据长度
 *pCipher，              输出参数，   加密结果，此空间需比ulPlainDataLen至少大48字节
 *pulCipherLen，         输入输出参数，输入时指分配空间pCipher大小，输出时指密文长度
 *返回值：
 *1，成功；0,密码计算出错；-1,调用参数错误;-2,分配空间/数据长度错误。
 */
ROBOT_CRYPTO_API int encryptR0B0TData(unsigned char * pCryptoFactor,unsigned int ulCryptoFactorLen,unsigned char * pPlainData,unsigned int ulPlainDataLen,unsigned char * pCipher,unsigned int * pulCipherLen);

/**
 *函数说明：解密密文数据
 *参数说明：
 *pCryptoFactor，        输入参数，   密码运算因子，需与加密时的赋值相同
 ulCryptoFactorLen，    输入参数，   密码运算因子长度
 *pCipher，              输出参数，   密文数据
 ulCipherLen，          输入参数，   以字节计算的密文数据长度
 *pPlainData，           输入参数，   解密明文数据，此空间需大于等于pulCipherLen
 *pulPlainDataLen，      输入输出参数，输入时指分配空间pPlainData大小，输出时指明文长度
 **返回值：
 *1，成功；0,密码计算出错；-1,调用参数错误;-2,分配空间/数据长度错误;-3,MAC验证错误。
 */
ROBOT_CRYPTO_API int decryptR0B0TData(unsigned char * pCryptoFactor,unsigned int ulCryptoFactorLen,unsigned char * pCipher,unsigned int pulCipherLen,unsigned char * pPlainData,unsigned int * ulPlainDataLen);

#endif /* robotCrypto_h */
