#ifndef AUBOCAPSPP_H
#define AUBOCAPSPP_H

#include <aubo_caps/contribution/program/program_api_provider.h>

namespace arcs {
namespace aubo_scope {

class RecordChangesHelper
{
    ProgramApiProviderPtr api_provider_{ nullptr };

public:
    RecordChangesHelper(ProgramApiProviderPtr api_provider)
        : api_provider_(api_provider)
    {
    }

    void operator()(const std::string &text,
                    std::function<void()> undoableChanges)
    {
        if (api_provider_) {
            api_provider_->getProgramApi()->getUndoRedoManager()->recordChanges(
                text, undoableChanges);
        }
    }
};

}
}

#endif

