#ifndef AUBO_SCOPE_MODEL_COMBOBOX_H
#define AUBO_SCOPE_MODEL_COMBOBOX_H

#include <functional>
#include <QComboBox>
#include <QAbstractItemView>
#include <aubo_caps/class_forward.h>

namespace arcs {
namespace aubo_scope {

using Filter = std::function<bool(const std::string &)>;

template <typename T>
class ModelComboBox
{
    typedef std::shared_ptr<T> ModelPtr;

public:
    ModelComboBox(
        QComboBox *parent, ModelPtr model,
        Filter filter = [](const std::string &) { return true; })
        : cmb_(parent), model_(model)
    {
        name_ = model_->connectedTo(
            "ModelComboBox",
            [this](ModelPtr /*model*/) { updateVaraibleNames(); });

        filter_ = filter;

        QObject::connect(cmb_->view(), &QAbstractItemView::clicked,
                         [this](const QModelIndex &index) {
                             if (index.row() == 0) {
                                 // emit createNew();
                             }
                         });
    }
    ~ModelComboBox() { model_->disconnectFrom(name_); }

private:
    void updateVaraibleNames()
    {
        QStringList texts;
        texts << QObject::tr("Create new");
        auto vars = model_->getAll();
        for (auto var : vars) {
            auto n = var->getDisplayName();
            if (filter_ && filter_(n)) {
                texts << QString::fromStdString(n);
            }
        }

        // 移除所有
        // model()->removeRows(0, model()->rowCount());
        cmb_->blockSignals(true);
        cmb_->clear();

        // 重新添加
        cmb_->addItems(texts);
        cmb_->blockSignals(false);
    }

private:
    QComboBox *cmb_;
    ModelPtr model_;
    Filter filter_;
    std::string name_;
};

} // namespace aubo_scope
} // namespace arcs
#endif
