#ifndef AUBO_CAPS_PP_PROGRAM_VIEW_HELPER_H
#define AUBO_CAPS_PP_PROGRAM_VIEW_HELPER_H

#include <QWidget>
#include <QLayout>

#include <aubo_caps/contribution/program/program_node_view.h>
#include <aubo_caps/contribution/view_api_provider.h>

namespace arcs {
namespace aubo_scope {

template <class T>
class ProgramViewHelper : public ProgramNodeView
{
public:
    template <typename... ARGS>
    ProgramViewHelper(ARGS... args)
    {
        ui_ = new T(args...);
    }

    void buildUi(WidgetHandle parent,
                 ContributionProviderPtr<ProgramNodeContribution>
                     contribution_provider) override
    {
        ((QWidget *)parent)->layout()->addWidget(ui_);
        ui_->setupUi(contribution_provider);
    }

    /// 返回 buildUi 创建的 UI 界面
    T *getUi() { return ui_; }

private:
    /// QtCreator 生成的 UI 类示例，借用 Qt 的对象释放机制
    T *ui_;
};

} // namespace aubo_scope
} // namespace arcs

#endif
