#ifndef AUBO_SCOPE_CONTRIBUTION_PROVIDER_H
#define AUBO_SCOPE_CONTRIBUTION_PROVIDER_H

#include <memory>
#include <aubo_caps/contribution/program/program_node_contribution.h>

namespace arcs {
namespace aubo_scope {

/**
 * This interfaces provides access to a contribution/
 * <p>
 * NOTE: This interface is not relevant for contributions with a HTML-based user
 * interface.
 * </p>
 *
 * @tparam <T> the (generic) type parameter for the interface representing the
 * type of contribution the interface provides access to
 */
template <class T>
class ContributionProvider
{
public:
    virtual ~ContributionProvider() = default;

    /**
     * Gets a contribution/ Call this as the result of a user action to get the
     * currently selected node.
     *
     * @return the relevant contribution
     */
    virtual T *get() = 0;
};

template <class T>
using ContributionProviderPtr = std::shared_ptr<ContributionProvider<T>>;

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_CONTRIBUTION_PROVIDER_H
