#ifndef AUBO_SCOPE_GRIPPER_API_PROVIDER_H
#define AUBO_SCOPE_GRIPPER_API_PROVIDER_H

#include <aubo_caps/domain/system_api.h>
#include <aubo_caps/domain/io/io_model.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(GripperApiProvider);

/**
 * This interface provides access to functionality and services available from
 * within AuboScope relevant for gripper contributions.
 */
class GripperApiProvider
{
public:
    virtual ~GripperApiProvider() = default;

    /**
     * @return An interface providing access to system related functionality.
     */
    virtual SystemApiPtr getSystemApi() = 0;

    /**
     * @return An I/O model interface (e.g. for getting I/Os to display in the
     * custom user input for setting up the gripper)
     */
    virtual IoModelPtr getIoModel() = 0;
};
} // namespace aubo_scope
} // namespace arcs

#endif
