#ifndef AUBO_SCOPE_SCREW_DIRVER_API_PROVIDER_H
#define AUBO_SCOPE_SCREW_DIRVER_API_PROVIDER_H

#include <aubo_caps/domain/system_api.h>
#include <aubo_caps/domain/io/io_model.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(ScrewdriverApiProvider);

/**
 * This interface provides access to functionality and services available from
 * within AuboScope relevant for screwdriver contributions.
 */
class ScrewdriverApiProvider
{
public:
    virtual ~ScrewdriverApiProvider() = default;

    /**
     * @return an interface providing access to system related functionality.
     */
    virtual SystemApiPtr getSystemAPI() = 0;

    /**
     * @return an I/O model interface (e.g. for getting I/Os to display in the
     * custom user input for setting up the screwdriver)
     */
    virtual IoModelPtr getIOModel() = 0;
};
} // namespace aubo_scope
} // namespace arcs
#endif
