#ifndef AUBO_SCOPE_INSTALLATION_API_PROVIDER_H
#define AUBO_SCOPE_INSTALLATION_API_PROVIDER_H

#include <aubo_caps/domain/application_api.h>
#include <aubo_caps/domain/system_api.h>
#include <aubo_caps/domain/user_interface/user_interface_api.h>
#include <aubo_caps/domain/installation/installation_api.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(InstallationApiProvider);

/**
 * Provides access to functionality and services relevant for installation
 * nodes. This includes what is available from within AuboScope, as well as
 * creating additional model elements to be used within AuboScope.
 */
class InstallationApiProvider
{
public:
    InstallationApiProvider(InstallationApiProvider &f);
    InstallationApiProvider(InstallationApiProvider &&f);
    virtual ~InstallationApiProvider();

    /**
     * Provides access to system related functionality
     *
     * @return an instance of SystemAPI
     */
    SystemApiPtr getSystemApi();

    /**
     * Provides access to functionality related to user interface and end user
     * interaction
     *
     * @return an instance of UserInterfaceAPI
     */
    UserInterfaceApiPtr getUserInterfaceApi();

    /**
     * Provides access to functionality relevant related to the installation
     *
     * @return an instance of InstallationAPI
     */
    InstallationApiPtr getInstallationApi();

private:
    friend class DataSwitch;
    InstallationApiProvider();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // INSTALLATIONAPIPROVIDER_H
