#ifndef AUBO_SCOPE_INSTALLATION_CREATION_CONTEXT_H
#define AUBO_SCOPE_INSTALLATION_CREATION_CONTEXT_H

#include <aubo_caps/class_forward.h>

namespace arcs {
namespace aubo_scope {

ARCS_CLASS_FORWARD(InstallationCreationContext);

/**
 * Provides information about the context in which an installation node is
 * created
 */
class InstallationCreationContext
{
public:
    enum NodeCreationType
    {
        NEW,
        LOAD
    };

    InstallationCreationContext(InstallationCreationContext &f);
    InstallationCreationContext(InstallationCreationContext &&f);
    ~InstallationCreationContext();

    NodeCreationType getNodeCreationType();

    std::string getCreatedVersion();
    std::string getLastSavedVersion();

private:
    friend class DataSwitch;
    InstallationCreationContext();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_INSTALLATION_CREATION_CONTEXT_H
