#ifndef AUBO_SCOPE_INSTALLATION_NODE_CONTRIBUTION_H
#define AUBO_SCOPE_INSTALLATION_NODE_CONTRIBUTION_H

#include <aubo_caps/domain/script/script_writer.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(InstallationNodeContribution);

/**
 *  API for installation node contributions.
 */
class InstallationNodeContribution
{
public:
    virtual ~InstallationNodeContribution() = default;

    /**
     * Called each time the end user opens this AuboCap contribution in the
     * Installation Tab.
     */
    virtual void openView() = 0;

    /**
     * Called each time the end user exits this AuboCap contribution in the
     * Installation Tab.
     */
    virtual void closeView() = 0;

    /**
     * Defines script code that is added to the beginning of the script code
     * executed when a program is launched.
     *
     * @param writer serves to add script commands to program script code
     * preamble.
     */
    virtual void generateScript(ScriptWriterPtr script_writer) = 0;
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_INSTALLATIONNODECONTRIBUTION_H
