#ifndef AUBO_SCOPE_INSTALLATION_NODE_VIEW_H
#define AUBO_SCOPE_INSTALLATION_NODE_VIEW_H

#include <aubo_caps/class_forward.h>
#include <aubo_caps/contribution/installation/installation_node_contribution.h>

typedef long WidgetHandle;

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(InstallationNodeView);

/**
 * API for an installation node View which defines the UI for the corresponding
 * {@link InstallationNodeContribution}
 *
 * @param <C>  the (generic) type parameter for the interface representing the
 * type of the
 *             {@link InstallationNodeContribution} for which this view
 * implements the UI
 */
class InstallationNodeView
{
public:
    virtual ~InstallationNodeView() = default;

    /**
     * Build the UI for the corresponding {@link InstallationNodeContribution}
     * on the provided panel. Use the contribution for your logic and data model
     * manipulations.
     *
     * @param panel the panel to build the UI on
     * @param contribution the corresponding installation node contribution/
     */
    virtual void buildUi(WidgetHandle panel,
                         InstallationNodeContributionPtr contribution) = 0;
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_INSTALLATION_NODE_VIEW_H
