#ifndef AUBO_SCOPE_PROGRAM_API_PROVIDER_H
#define AUBO_SCOPE_PROGRAM_API_PROVIDER_H

#include <aubo_caps/domain/system_api.h>
#include <aubo_caps/domain/program/program_api.h>
#include <aubo_caps/domain/user_interface/user_interface_api.h>

namespace arcs {
namespace aubo_scope {

ARCS_CLASS_FORWARD(ProgramApiProvider);

/**
 * Provides access to functionality and services relevant for program nodes.
 * This includes what is available from within AuboScope, as well as creating
 * additional model elements to be used within AuboScope.
 */
class ProgramApiProvider
{
public:
    ProgramApiProvider(ProgramApiProvider &f);
    ProgramApiProvider(ProgramApiProvider &&f);
    virtual ~ProgramApiProvider();

    /**
     * Provides access to system related functionality
     *
     * @return an instance of SystemAPI
     */
    SystemApiPtr getSystemApi();

    /**
     * Provides access to functionality related to user interface and end user
     * interaction
     *
     * @return an instance of UserInterfaceAPI
     */
    UserInterfaceApiPtr getUserInterfaceApi();

    /**
     * Provides access to functionality relevant related to programs
     *
     * @return an instance of ProgramAPI
     */
    ProgramApiPtr getProgramApi();

private:
    ProgramApiProvider();
    friend class DataSwitch;
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_PROGRAM_API_PROVIDER_H
