#ifndef AUBO_SCOPE_PROGRAM_CREATION_CONTEXT_H
#define AUBO_SCOPE_PROGRAM_CREATION_CONTEXT_H

#include <aubo_caps/class_forward.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(ProgramCreationContext);

/**
 * Provides information about the context in which an installation node is
 * created
 */
class ProgramCreationContext
{
public:
    enum NodeCreationType
    {
        NEW,
        LOAD
    };

    ProgramCreationContext(ProgramCreationContext &f);
    ProgramCreationContext(ProgramCreationContext &&f);
    ~ProgramCreationContext();

    NodeCreationType getNodeCreationType();

    std::string getCreatedVersion();
    std::string getLastSavedVersion();

private:
    friend class DataSwitch;
    ProgramCreationContext();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_PROGRAM_CREATION_CONTEXT_H
