#ifndef AUBO_SCOPE_PROGRAM_NODE_VIEW_H
#define AUBO_SCOPE_PROGRAM_NODE_VIEW_H

#include <aubo_caps/contribution/program/program_node_contribution.h>
#include <aubo_caps/contribution/contribution_provider.h>

namespace arcs {
namespace aubo_scope {
typedef long WidgetHandle;
ARCS_CLASS_FORWARD(ProgramNodeView);

/**
 * API for a program node View which defines the UI for the corresponding {@link
 * ProgramNodeContribution}. The instance of {@link SwingProgramNodeView} is a
 * shared entity between several contributions.
 */
class ProgramNodeView
{
public:
    virtual ~ProgramNodeView() = default;

    /**
     * Build the UI for the corresponding {@link ProgramNodeContribution} on the
     * provided panel. Use the contribution for your logic and data model
     * manipulations.
     *
     * @param panel the panel to build the UI on
     * @param provider the provider for corresponding program node contribution
     * currently selected (in the program tree)
     */
    virtual void buildUi(
        WidgetHandle panel,
        ContributionProviderPtr<ProgramNodeContribution> provider) = 0;
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_PROGRAM_NODE_VIEW_H
