#ifndef AUBO_SCOPE_VIEW_API_PROVIDER_H
#define AUBO_SCOPE_VIEW_API_PROVIDER_H

#include <aubo_caps/domain/system_api.h>
#include <aubo_caps/domain/user_interface/user_interface_api.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(ViewApiProvider);

/**
 * <p>
 * Provides access to functionality relevant for the View (UI) of an
 * installation or a program node contribution/
 * </p>
 *
 * <b>NOTE:</b> This interface is not relevant for AuboCap program and
 * installation nodes with a HTML-based user interface.
 */
class ViewApiProvider
{
public:
    ViewApiProvider();
    ViewApiProvider(ViewApiProvider &f);
    ViewApiProvider(ViewApiProvider &&f);
    virtual ~ViewApiProvider();

    /**
     * Provides access to system related functionality.
     *
     * @return an instance of SystemAPI.
     */
    SystemApiPtr getSystemApi();

    /**
     * Provides access to functionality related to user interface and user
     * interaction.
     *
     * @return an instance of UserInterfaceAPI.
     */
    UserInterfaceApiPtr getUserInterfaceApi();

private:
    friend class DataSwitch;
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_VIEW_API_PROVIDER_H
