#ifndef AUBO_SCOPE_DEVICE_MANAGER_H
#define AUBO_SCOPE_DEVICE_MANAGER_H

#include <vector>
#include <aubo_caps/domain/device/gripper_device.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(DeviceManager);

/**
 * <p>
 * Base interface for device managers.
 * </p>
 *
 * A device manager provides functionality for a specific type of device
 * supported by AuboScope. The device manager can provide functionality for,
 * e.g. accessing all registered devices (of that type) and using a specific
 * device in a program.
 */
class ARCS_ABI_EXPORT DeviceManager
{
public:
    virtual ~DeviceManager() = default;

    /**
     * @return The list of grippers (gripper devices) available in AuboScope
     */
    virtual std::vector<GripperDevicePtr> getGrippers() = 0;

    /**
     * @return The list of grippers (gripper devices) available in AuboScope
     */
    virtual std::vector<DevicePtr> getScrewDrivers() = 0;
};
} // namespace aubo_scope
} // namespace arcs

#endif
