#ifndef AUBO_SCOPE_DEVICE_REGISTERATION_MANAGER_H
#define AUBO_SCOPE_DEVICE_REGISTERATION_MANAGER_H

#include <aubo_caps/contribution/driver/gripper/gripper_contribution.h>
#include <aubo_caps/contribution/driver/screw_driver/screw_driver_contribution.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(DeviceRegistrationManager);

/**
 * <p>
 * Base interface for device registration managers.
 * </p>
 *
 * A device registration manager is used for registering a program/installation
 * node contribution/service as conformant with a specific device type supported
 * by AuboScope.
 */
class ARCS_ABI_EXPORT DeviceRegistrationManager
{
public:
    virtual ~DeviceRegistrationManager() = default;

    /**
     * @brief registerGripperContribution
     * @param contribution
     */
    virtual void registerGripperContribution(
        GripperContributionPtr contribution) = 0;

    /**
     * @brief registerScrewDriverContribution
     * @param contribution
     */
    virtual void registerScrewDriverContribution(
        ScrewdriverContributionPtr contribution) = 0;
};
} // namespace aubo_scope
} // namespace arcs

#endif
