#ifndef AUBO_SCOPE_EXTENSION_INFO_H
#define AUBO_SCOPE_EXTENSION_INFO_H

#include <string>
#include <aubo_caps/class_forward.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(AuboCapInfo);

/**
 * This interface provides various metadata information about an installed
 * AuboCap, such as the name of the AuboCap.
 *
 * @since 1.1.0
 */
class ARCS_ABI_EXPORT AuboCapInfo
{
public:
    virtual ~AuboCapInfo() = default;

    /**
     * @retAubon The symbolic name (id) of the AuboCap.
     */
    virtual std::string getSymbolicName() = 0;

    /**
     * @retAubon The name of the AuboCap.
     */
    virtual std::string getName() = 0;

    /**
     * @retAubon The vendor of the AuboCap.
     */
    virtual std::string getVendor() = 0;
};
} // namespace aubo_scope
} // namespace arcs

#endif
