#ifndef AUBO_SCOPE_FEATURE_MODEL_H
#define AUBO_SCOPE_FEATURE_MODEL_H

#include <vector>
#include <functional>
#include <aubo_caps/domain/feature/feature.h>

namespace arcs {
namespace aubo_scope {

ARCS_CLASS_FORWARD(FeatureModel);

/**
 * Provides methods that returns features from the current robot installation.
 */
class ARCS_ABI_EXPORT FeatureModel
{
public:
    FeatureModel(FeatureModel &f);
    FeatureModel(FeatureModel &&f);
    ~FeatureModel();

    std::vector<FeaturePtr> getAll();

    /**
     * @return the geometric features of the current installation
     */
    /**
     * @param clazz the sort of geometric feature of interest, e.g.
     * <code>FeaturePoint.class</code>,
     *              <code>FeatureLine.class</code>,
     * <code>FeaturePlane.class</code>
     * @param <T> The Feature type
     * @return the collection of the corresponding features
     */
    template <typename T>
    std::vector<FeaturePtr> getGeomFeture();

    FeaturePtr getByName(const std::string &name);

    /**
     * @return the base feature of the current installation.
     */
    FeaturePtr getBaseFeature();

    /**
     * @return the tool feature of the current installation.
     */
    FeaturePtr getToolFeature();

    std::vector<FeaturePtr> getFeatures(std::function<bool(FeaturePtr)> filter);

private:
    friend class DataSwitch;
    FeatureModel();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_FEATURE_MODEL_H
