#ifndef AUBO_SCOPE_FUNCTION_H
#define AUBO_SCOPE_FUNCTION_H

#include <vector>
#include <aubo_caps/domain/extension_info.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(Function);

/**
 * <p>
 * Represents a function shown in the Expression Editor.
 * </p>
 *
 * See also {@link FunctionModel}.
 */
class ARCS_ABI_EXPORT Function
{
public:
    Function(Function &f);
    Function(Function &&f);
    ~Function();

    /**
     * @return The name of the function.
     */
    std::string getName();

    /**
     * @return A list of the arguments of the function.
     */
    std::vector<std::string> getArguments();

    /**
     * Get information about the AuboCap that added/contributed this gripper
     * device to AuboScope.
     *
     * @return AuboCap information for this gripper device
     */
    AuboCapInfoPtr getContributorInfo();

private:
    friend class DataSwitch;
    Function();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_FUNCTION_H
