#ifndef AUBO_SCOPE_INSTALLATION_API_H
#define AUBO_SCOPE_INSTALLATION_API_H

#include <aubo_caps/domain/application_api.h>
#include <aubo_caps/domain/function/function_model.h>
#include <aubo_caps/domain/tcp/tcp_contribution_model.h>
#include <aubo_caps/domain/feature/feature_contribution_model.h>
#include <aubo_caps/domain/payload/payload_contribution_model.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(InstallationApi);

/**
 * Provides access to functionality and services related to the installation.
 * This includes what is available from within AuboScope, as well as creating
 * additional model elements to be used within AuboScope.
 */
class ARCS_ABI_EXPORT InstallationApi : public ApplicationApi
{
public:
    InstallationApi(InstallationApi &f);
    InstallationApi(InstallationApi &&f);
    virtual ~InstallationApi();

    /**
     * @return An interface for adding script functions to AuboScope
     */
    FunctionModelPtr getFunctionModel();

    /**
     * @return An interface for contributing TCPs to AuboScope
     */
    TcpContributionModelPtr getTcpContributionModel();

    /**
     * @return An interface for contributing features to AuboScope
     */
    FeatureContributionModelPtr getFeatureContributionModel();

    /**
     * <p>
     * Gets an interface which provides functionality for contributing payloads
     * to the AuboScope installation.
     * </p>
     *
     * @return An interface for contributing payloads to AuboScope
     */
    PayloadContributionModelPtr getPayloadContributionModel();

private:
    friend class DataSwitch;
    InstallationApi();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_INSTALLATION_API_H
