#ifndef AUBO_SCOPE_ANALOG_IO_H
#define AUBO_SCOPE_ANALOG_IO_H

#include <aubo_caps/domain/io/io.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(AnalogIo);

/**
 * This interface provides support for analog I/Os.
 *
 */
class ARCS_ABI_EXPORT AnalogIo : public Io
{
public:
    AnalogIo(AnalogIo &f);
    AnalogIo(AnalogIo &&f);
    ~AnalogIo();

    double getMinRangeValue();
    double getMaxRangeValue();

    bool isCurrent();
    bool isVoltage();

    /**
     * Set analog I/O output signal. Notice the I/O must be an output I/O
     *
     * @param value The analog value to be set.
     * @return <code>true</code> if the analog signal was set,
     * <code>false</code> if the signal was not set, e.g. because the controller
     * was not running.
     */
    bool setValue(double value);

    /**
     *
     * @return Returns the last reading of the I/O.
     */
    double getValue();

private:
    friend class DataSwitch;
    AnalogIo();
    void *d_{ nullptr };
};

struct AnalogIoFilter
{
    AnalogIoFilter(Io::InterfaceType interface, bool is_input)
        : interface_(interface), is_input_(is_input)
    {
    }
    bool operator()(IoPtr io)
    {
        return std::dynamic_pointer_cast<AnalogIo>(io) != nullptr &&
               io->getInterfaceType() == interface_ &&
               io->isInput() == is_input_;
    }

private:
    Io::InterfaceType interface_;
    bool is_input_;
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_ANALOG_IO_H
