#ifndef AUBO_SCOPE_DIGITAL_IO_H
#define AUBO_SCOPE_DIGITAL_IO_H

#include <aubo_caps/domain/io/io.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(DigitalIo);

/**
 * This interface provides support for digital I/Os.
 *
 */
class ARCS_ABI_EXPORT DigitalIo : public Io
{
public:
    DigitalIo(DigitalIo &f);
    DigitalIo(DigitalIo &&f);
    ~DigitalIo();

    /**
     * Set digital I/O output signal. Note that the I/O must be an output I/O.
     *
     * @param high the digital value to be set.
     * @return <code>true</code> if the digital signal was set,
     * <code>false</code> if the signal was not set, e.g. because the controller
     * was not running.
     */
    bool setValue(bool high);

    /**
     *
     * @return Returns the last reading of the I/O.
     */
    bool getValue();

private:
    friend class DataSwitch;
    DigitalIo();
    void *d_{ nullptr };
};

struct DigitalIoFilter
{
    DigitalIoFilter(Io::InterfaceType interface, bool is_input)
        : interface_(interface), is_input_(is_input)
    {
    }
    bool operator()(IoPtr io)
    {
        return std::dynamic_pointer_cast<DigitalIo>(io) != nullptr &&
               io->getInterfaceType() == interface_ &&
               io->isInput() == is_input_;
    }

private:
    Io::InterfaceType interface_;
    bool is_input_;
};

struct InputIoFilter
{
    bool operator()(IoPtr io) { return io && io->isInput(); }
};

struct OutputIoFilter
{
    bool operator()(IoPtr io) { return io && !io->isInput(); }
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_DIGITAL_IO_H
