#ifndef AUBO_SCOPE_IO_MODEL_H
#define AUBO_SCOPE_IO_MODEL_H

#include <vector>
#include <functional>
#include <aubo_caps/class_forward.h>
#include <aubo_caps/domain/io/io.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(IoModel);

/**
 * Provides methods that returns I/Os from the current robot installation.
 *
 */
class ARCS_ABI_EXPORT IoModel
{
public:
    IoModel(IoModel &f);
    IoModel(IoModel &&f);
    ~IoModel();

    /**
     *
     * @return the collection of available I/Os, including Modbus, EuroMap67 and
     * named General Purpose Registers.
     */
    std::vector<IoPtr> getAll();

    IoPtr getIo(const std::string &name);

    /**
     *
     * @param filter, see {@link IOFilterFactory}
     * @return the collection of IOs that are accepted by the filter.
     */
    std::vector<IoPtr> getIos(std::function<bool(IoPtr)> filter);

private:
    friend class DataSwitch;
    IoModel();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif
