#ifndef AUBO_SCOPE_PAYLOAD_MODEL_H
#define AUBO_SCOPE_PAYLOAD_MODEL_H

#include <vector>
#include <aubo_caps/class_forward.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(PayloadModel);
ARCS_CLASS_FORWARD(Payload);

class ARCS_ABI_EXPORT PayloadModel
{
public:
    PayloadModel(PayloadModel &f);
    PayloadModel(PayloadModel &&f);
    virtual ~PayloadModel();

    /**
     * @return A collection of all the payloads from the current
     * installation in AuboScope, including user-defined payloads and
     * payloads added by aubo_studio plugins.
     */
    std::vector<PayloadPtr> getPayloads() const;

    PayloadPtr getPayload(const std::string &name) const;

    PayloadPtr getDefaultPayload() const;
    PayloadPtr getCurrentPayload() const;

private:
    friend class DataSwitch;
    PayloadModel();
    void *d_{ nullptr };
};
} // namespace aubo_scope
} // namespace arcs

#endif // PAYLOADMODEL_H
