#ifndef AUBO_SCOPE_ASSEMBLY_NODE_H
#define AUBO_SCOPE_ASSEMBLY_NODE_H

#include <aubo_caps/domain/program/nodes/program_node.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(AssemblyNode);

class ARCS_ABI_EXPORT AssemblyNode : public ProgramNode
{
public:
    enum ConfigType
    {
        NONE,
        HOLE_SEARCH,
        COMPLIANT_INSERTION
    };

    AssemblyNode(AssemblyNode &f);
    AssemblyNode(AssemblyNode &&f);
    virtual ~AssemblyNode();

    void addAssemblyUntilNode();

private:
    friend class DataSwitch;
    AssemblyNode();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_ASSEMBLY_NODE_H
