#ifndef AUBO_SCOPE_ASSIGNMENT_NODE_H
#define AUBO_SCOPE_ASSIGNMENT_NODE_H

#include <aubo_caps/domain/program/nodes/program_node.h>
#include <aubo_caps/domain/variable/variable.h>
#include <aubo_caps/domain/value/expression/expression.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(AssignmentNode);

class ARCS_ABI_EXPORT AssignmentNode : public ProgramNode
{
public:
    /**
     * The configuration type used to determine which type of configuration this
     * instance is.
     */
    enum ConfigType
    {
        /**
         * <p>
         * Expression assignment has been selected.
         * </p>
         *
         * The config instance can be cast to {@link
         * ExpressionAssignmentNodeConfig}.
         */
        EXPRESSION,

        /**
         * Operator assignment has been selected. This type has no further
         * information. Setting this type of config will be ignored and will
         * have no effect on the node.
         */
        OPERATOR
    };

    enum InputMode
    {
        INPUT_BOOL,
        INPUT_INTEGER,
        INPUT_FLOAT,
        INPUT_STRING,
    };

    AssignmentNode(AssignmentNode &f);
    AssignmentNode(AssignmentNode &&f);
    virtual ~AssignmentNode();

    /**
     * <p>
     *
     * </p>
     * @return
     */
    ConfigType getConfigType();
    void setConfigType(ConfigType type);

    /**
     *
     * @return the variable assigned to the expression evaluation.
     */
    VariablePtr getVariable();
    void setVariable(VariablePtr var);

    /**
     *
     * @return the expression whose evaluation is assigned to the variable.
     */
    ExpressionPtr getExpression();
    void setExpression(ExpressionPtr exp);

private:
    friend class DataSwitch;
    AssignmentNode();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_ASSIGNMENT_NODE_H
