#ifndef AUBO_SCOPE_COMMENT_NODE_H
#define AUBO_SCOPE_COMMENT_NODE_H

#include <string>
#include <aubo_caps/domain/program/nodes/program_node.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(CommentNode);

class ARCS_ABI_EXPORT CommentNode : public ProgramNode
{
public:
    CommentNode(CommentNode &f);
    CommentNode(CommentNode &&f);
    virtual ~CommentNode();

    /**
     *
     * @return The text of the Comment node.
     */
    std::string getComment() const;

    /**
     * * Set the text for the Comment node.
     * @param comment The Comment for the node.
     * @return This node.
     */
    void setComment(const std::string &param_string);

private:
    friend class DataSwitch;
    CommentNode();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_COMMENT_NODE_H
